/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class GeneralizedExtremeValueDistribution
extends AbstractDistribution {
    final double mu;
    final double sigma;
    final double k;

    public GeneralizedExtremeValueDistribution(double mu, double sigma, double k) {
        this(mu, sigma, k, (Random)null);
    }

    public GeneralizedExtremeValueDistribution(double mu, double sigma, double k, RandomFactory random) {
        super(random);
        this.mu = mu;
        this.sigma = sigma;
        this.k = k;
    }

    public GeneralizedExtremeValueDistribution(double mu, double sigma, double k, Random random) {
        super(random);
        this.mu = mu;
        this.sigma = sigma;
        this.k = k;
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    public double getK() {
        return this.k;
    }

    @Override
    public double pdf(double x) {
        return GeneralizedExtremeValueDistribution.pdf(x, this.mu, this.sigma, this.k);
    }

    public static double pdf(double x, double mu, double sigma, double k) {
        if (x == Double.POSITIVE_INFINITY || x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        x = (x - mu) / sigma;
        if (k > 0.0 || k < 0.0) {
            if (k * x > 1.0) {
                return 0.0;
            }
            double t = FastMath.log(1.0 - k * x);
            return t == Double.NEGATIVE_INFINITY ? 1.0 / sigma : (t == Double.POSITIVE_INFINITY ? 0.0 : FastMath.exp((1.0 - k) * t / k - FastMath.exp(t / k)) / sigma);
        }
        return FastMath.exp(-x - FastMath.exp(-x)) / sigma;
    }

    @Override
    public double logpdf(double x) {
        return GeneralizedExtremeValueDistribution.logpdf(x, this.mu, this.sigma, this.k);
    }

    public static double logpdf(double x, double mu, double sigma, double k) {
        if (x == Double.POSITIVE_INFINITY || x == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        x = (x - mu) / sigma;
        if (k > 0.0 || k < 0.0) {
            if (k * x > 1.0) {
                return Double.NEGATIVE_INFINITY;
            }
            double t = FastMath.log(1.0 - k * x);
            return t == Double.NEGATIVE_INFINITY ? -FastMath.log(sigma) : (t == Double.POSITIVE_INFINITY ? Double.NEGATIVE_INFINITY : (1.0 - k) * t / k - FastMath.exp(t / k) - FastMath.log(sigma));
        }
        return -x - FastMath.exp(-x) - FastMath.log(sigma);
    }

    @Override
    public double cdf(double val) {
        return GeneralizedExtremeValueDistribution.cdf(val, this.mu, this.sigma, this.k);
    }

    public static double cdf(double val, double mu, double sigma, double k) {
        double x = (val - mu) / sigma;
        if (k > 0.0 || k < 0.0) {
            if (k * x > 1.0) {
                return k > 0.0 ? 1.0 : 0.0;
            }
            return FastMath.exp(-FastMath.exp(FastMath.log(1.0 - k * x) / k));
        }
        return FastMath.exp(-FastMath.exp(-x));
    }

    @Override
    public double quantile(double val) {
        return GeneralizedExtremeValueDistribution.quantile(val, this.mu, this.sigma, this.k);
    }

    public static double quantile(double val, double mu, double sigma, double k) {
        if (val < 0.0 || val > 1.0) {
            return Double.NaN;
        }
        if (k < 0.0) {
            return mu + sigma * Math.max((1.0 - FastMath.pow(-FastMath.log(val), k)) / k, 1.0 / k);
        }
        if (k > 0.0) {
            return mu + sigma * Math.min((1.0 - FastMath.pow(-FastMath.log(val), k)) / k, 1.0 / k);
        }
        return mu + sigma * FastMath.log(1.0 / FastMath.log(1.0 / val));
    }

    @Override
    public String toString() {
        return "GeneralizedExtremeValueDistribution(sigma=" + this.sigma + ", mu=" + this.mu + ", k=" + this.k + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double mu;
        double sigma;
        double k;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter kP;
            DoubleParameter sigmaP;
            super.makeOptions(config);
            DoubleParameter muP = new DoubleParameter(LOCATION_ID);
            if (config.grab(muP)) {
                this.mu = muP.doubleValue();
            }
            if (config.grab(sigmaP = new DoubleParameter(SCALE_ID))) {
                this.sigma = sigmaP.doubleValue();
            }
            if (config.grab(kP = new DoubleParameter(SHAPE_ID))) {
                this.k = kP.doubleValue();
            }
        }

        @Override
        protected GeneralizedExtremeValueDistribution makeInstance() {
            return new GeneralizedExtremeValueDistribution(this.mu, this.sigma, this.k, this.rnd);
        }
    }
}

