/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class GeneralizedLogisticAlternateDistribution
extends AbstractDistribution {
    double location;
    double scale;
    double shape;

    public GeneralizedLogisticAlternateDistribution(double location, double scale, double shape) {
        this(location, scale, shape, (Random)null);
    }

    public GeneralizedLogisticAlternateDistribution(double location, double scale, double shape, Random random) {
        super(random);
        this.location = location;
        this.scale = scale;
        this.shape = shape;
        if (!(shape > -1.0) || !(shape < 1.0)) {
            throw new ArithmeticException("Invalid shape parameter - must be -1 to +1, is: " + shape);
        }
    }

    public GeneralizedLogisticAlternateDistribution(double location, double scale, double shape, RandomFactory random) {
        super(random);
        this.location = location;
        this.scale = scale;
        this.shape = shape;
        if (!(shape > -1.0) || !(shape < 1.0)) {
            throw new ArithmeticException("Invalid shape parameter - must be -1 to +1, is: " + shape);
        }
    }

    public double getScale() {
        return this.scale;
    }

    public double getShape() {
        return this.shape;
    }

    public double getLocation() {
        return this.location;
    }

    public static double pdf(double val, double loc, double scale, double shape) {
        val = (val - loc) / scale;
        if (shape != 0.0) {
            val = -FastMath.log(1.0 - shape * val) / shape;
        }
        double f = 1.0 + FastMath.exp(-val);
        return FastMath.exp(-val * (1.0 - shape)) / (scale * f * f);
    }

    @Override
    public double pdf(double val) {
        return GeneralizedLogisticAlternateDistribution.pdf(val, this.location, this.scale, this.shape);
    }

    public static double logpdf(double val, double loc, double scale, double shape) {
        val = (val - loc) / scale;
        if (shape != 0.0) {
            val = -FastMath.log(1.0 - shape * val) / shape;
        }
        double f = 1.0 + FastMath.exp(-val);
        return -val * (1.0 - shape) - FastMath.log(scale * f * f);
    }

    @Override
    public double logpdf(double val) {
        return GeneralizedLogisticAlternateDistribution.logpdf(val, this.location, this.scale, this.shape);
    }

    public static double cdf(double val, double loc, double scale, double shape) {
        val = (val - loc) / scale;
        if (shape != 0.0) {
            double tmp = 1.0 - shape * val;
            if (tmp < 1.0E-15) {
                return shape < 0.0 ? 0.0 : 1.0;
            }
            val = -FastMath.log(tmp) / shape;
        }
        return 1.0 / (1.0 + FastMath.exp(-val));
    }

    @Override
    public double cdf(double val) {
        return GeneralizedLogisticAlternateDistribution.cdf(val, this.location, this.scale, this.shape);
    }

    public static double quantile(double val, double loc, double scale, double shape) {
        if (shape == 0.0) {
            return loc - scale * FastMath.log((1.0 - val) / val);
        }
        return loc + scale * (1.0 - FastMath.pow((1.0 - val) / val, shape)) / shape;
    }

    @Override
    public double quantile(double val) {
        return GeneralizedLogisticAlternateDistribution.quantile(val, this.location, this.scale, this.shape);
    }

    @Override
    public double nextRandom() {
        double u = this.random.nextDouble();
        return GeneralizedLogisticAlternateDistribution.quantile(u, this.location, this.scale, this.shape);
    }

    @Override
    public String toString() {
        return "GeneralizedLogisticAlternateDistribution(location=" + this.location + ", scale=" + this.scale + ", shape=" + this.shape + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double location;
        double scale;
        double shape;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter shapeP;
            DoubleParameter scaleP;
            super.makeOptions(config);
            DoubleParameter locationP = new DoubleParameter(LOCATION_ID);
            if (config.grab(locationP)) {
                this.location = locationP.doubleValue();
            }
            if (config.grab(scaleP = new DoubleParameter(SCALE_ID))) {
                this.scale = scaleP.doubleValue();
            }
            if (config.grab(shapeP = new DoubleParameter(SHAPE_ID))) {
                this.shape = shapeP.doubleValue();
            }
        }

        @Override
        protected GeneralizedLogisticAlternateDistribution makeInstance() {
            return new GeneralizedLogisticAlternateDistribution(this.location, this.scale, this.shape, this.rnd);
        }
    }
}

