/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class GeneralizedLogisticDistribution
extends AbstractDistribution {
    double location;
    double scale;
    double shape;

    public GeneralizedLogisticDistribution(double location, double scale, double shape) {
        this(location, scale, shape, (Random)null);
    }

    public GeneralizedLogisticDistribution(double location, double scale, double shape, Random random) {
        super(random);
        this.location = location;
        this.scale = scale;
        this.shape = shape;
    }

    public GeneralizedLogisticDistribution(double location, double scale, double shape, RandomFactory random) {
        super(random);
        this.location = location;
        this.scale = scale;
        this.shape = shape;
    }

    @Override
    public double pdf(double val) {
        return GeneralizedLogisticDistribution.pdf(val, this.location, this.scale, this.shape);
    }

    public static double pdf(double val, double loc, double scale, double shape) {
        if (!(val < Double.POSITIVE_INFINITY) || !(val > Double.NEGATIVE_INFINITY)) {
            return val == val ? 0.0 : Double.NaN;
        }
        val = (val - loc) / scale;
        double e = FastMath.exp(-val);
        double f = 1.0 + e;
        return e < Double.POSITIVE_INFINITY ? shape * e / (scale * FastMath.pow(f, shape + 1.0)) : 0.0;
    }

    @Override
    public double logpdf(double val) {
        return GeneralizedLogisticDistribution.logpdf(val, this.location, this.scale, this.shape);
    }

    public static double logpdf(double val, double loc, double scale, double shape) {
        val = (val - loc) / scale;
        double e = FastMath.exp(-val);
        return -(val + (shape + 1.0) * FastMath.log1p(e)) + FastMath.log(shape);
    }

    @Override
    public double cdf(double val) {
        return GeneralizedLogisticDistribution.cdf(val, this.location, this.scale, this.shape);
    }

    public static double cdf(double val, double loc, double scale, double shape) {
        val = (val - loc) / scale;
        return FastMath.pow(1.0 + FastMath.exp(-val), -shape);
    }

    public static double logcdf(double val, double loc, double scale, double shape) {
        val = (val - loc) / scale;
        return FastMath.log1p(FastMath.exp(-val)) * -shape;
    }

    public static double quantile(double val, double loc, double scale, double shape) {
        return loc - scale * FastMath.log(FastMath.exp(FastMath.log(val) / -shape) - 1.0);
    }

    @Override
    public double quantile(double val) {
        return GeneralizedLogisticDistribution.quantile(val, this.location, this.scale, this.shape);
    }

    @Override
    public double nextRandom() {
        double u = this.random.nextDouble();
        return this.location - this.scale * FastMath.log(FastMath.exp(FastMath.log(u) / -this.shape) - 1.0);
    }

    @Override
    public String toString() {
        return "GeneralizedLogisticDistribution(location=" + this.location + ", scale=" + this.scale + ", shape=" + this.shape + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double location;
        double scale;
        double shape;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter shapeP;
            DoubleParameter scaleP;
            super.makeOptions(config);
            DoubleParameter locationP = new DoubleParameter(LOCATION_ID);
            if (config.grab(locationP)) {
                this.location = locationP.doubleValue();
            }
            if (config.grab(scaleP = new DoubleParameter(SCALE_ID))) {
                this.scale = scaleP.doubleValue();
            }
            if (config.grab(shapeP = new DoubleParameter(SHAPE_ID))) {
                this.shape = shapeP.doubleValue();
            }
        }

        @Override
        protected GeneralizedLogisticDistribution makeInstance() {
            return new GeneralizedLogisticDistribution(this.location, this.scale, this.shape, this.rnd);
        }
    }
}

