/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class GeneralizedParetoDistribution
extends AbstractDistribution {
    final double mu;
    final double sigma;
    final double xi;

    public GeneralizedParetoDistribution(double mu, double sigma, double xi) {
        this(mu, sigma, xi, (Random)null);
    }

    public GeneralizedParetoDistribution(double mu, double sigma, double xi, RandomFactory random) {
        super(random);
        this.mu = mu;
        this.sigma = sigma;
        this.xi = xi;
    }

    public GeneralizedParetoDistribution(double mu, double sigma, double xi, Random random) {
        super(random);
        this.mu = mu;
        this.sigma = sigma;
        this.xi = xi;
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    public double getXi() {
        return this.xi;
    }

    public static double pdf(double x, double mu, double sigma, double xi) {
        if ((x = (x - mu) / sigma) < 0.0 || xi < 0.0 && x > -1.0 / xi) {
            return 0.0;
        }
        return (xi == 0.0 ? 1.0 : FastMath.pow(1.0 + xi * x, -1.0 / xi - 1.0)) / sigma;
    }

    @Override
    public double pdf(double x) {
        return GeneralizedParetoDistribution.pdf(x, this.mu, this.sigma, this.xi);
    }

    public static double logpdf(double x, double mu, double sigma, double xi) {
        if ((x = (x - mu) / sigma) < 0.0 || xi < 0.0 && x > -1.0 / xi) {
            return Double.NEGATIVE_INFINITY;
        }
        if (xi == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return (xi == -1.0 ? 0.0 : FastMath.log(1.0 + xi * x) * (-1.0 / xi - 1.0)) - FastMath.log(sigma);
    }

    @Override
    public double logpdf(double x) {
        return GeneralizedParetoDistribution.logpdf(x, this.mu, this.sigma, this.xi);
    }

    public static double cdf(double val, double mu, double sigma, double xi) {
        if ((val = (val - mu) / sigma) < 0.0) {
            return 0.0;
        }
        if (xi < 0.0 && val > -1.0 / xi) {
            return 1.0;
        }
        return 1.0 - FastMath.pow(1.0 + xi * val, -1.0 / xi);
    }

    @Override
    public double cdf(double val) {
        return GeneralizedParetoDistribution.cdf(val, this.mu, this.sigma, this.xi);
    }

    public static double quantile(double val, double mu, double sigma, double xi) {
        if (val < 0.0 || val > 1.0) {
            return Double.NaN;
        }
        if (xi == 0.0) {
            return mu - sigma * FastMath.log(1.0 - val);
        }
        return mu - sigma / xi * (1.0 - FastMath.pow(1.0 - val, -xi));
    }

    @Override
    public double quantile(double val) {
        return GeneralizedParetoDistribution.quantile(val, this.mu, this.sigma, this.xi);
    }

    @Override
    public String toString() {
        return "GeneralizedParetoDistribution(sigma=" + this.sigma + ", mu=" + this.mu + ", xi=" + this.xi + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double mu;
        double sigma;
        double xi;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter xiP;
            DoubleParameter sigmaP;
            super.makeOptions(config);
            DoubleParameter muP = new DoubleParameter(LOCATION_ID);
            if (config.grab(muP)) {
                this.mu = muP.doubleValue();
            }
            if (config.grab(sigmaP = new DoubleParameter(SCALE_ID))) {
                this.sigma = sigmaP.doubleValue();
            }
            if (config.grab(xiP = new DoubleParameter(SHAPE_ID))) {
                this.xi = xiP.doubleValue();
            }
        }

        @Override
        protected GeneralizedParetoDistribution makeInstance() {
            return new GeneralizedParetoDistribution(this.mu, this.sigma, this.xi, this.rnd);
        }
    }
}

