/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class GumbelDistribution
extends AbstractDistribution {
    double mu;
    double beta;

    public GumbelDistribution(double mu, double beta) {
        this(mu, beta, (Random)null);
    }

    public GumbelDistribution(double mu, double beta, Random random) {
        super(random);
        this.mu = mu;
        this.beta = beta;
    }

    public GumbelDistribution(double mu, double beta, RandomFactory random) {
        super(random);
        this.mu = mu;
        this.beta = beta;
    }

    public double getMu() {
        return this.mu;
    }

    public double getBeta() {
        return this.beta;
    }

    public static double pdf(double x, double mu, double beta) {
        double z = (x - mu) / beta;
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return FastMath.exp(-z - FastMath.exp(-z)) / beta;
    }

    @Override
    public double pdf(double x) {
        return GumbelDistribution.pdf(x, this.mu, this.beta);
    }

    public static double logpdf(double x, double mu, double beta) {
        if (x == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        double z = (x - mu) / beta;
        return -z - FastMath.exp(-z) - FastMath.log(beta);
    }

    @Override
    public double logpdf(double x) {
        return GumbelDistribution.logpdf(x, this.mu, this.beta);
    }

    public static double cdf(double val, double mu, double beta) {
        return FastMath.exp(-FastMath.exp(-(val - mu) / beta));
    }

    @Override
    public double cdf(double val) {
        return GumbelDistribution.cdf(val, this.mu, this.beta);
    }

    public static double quantile(double val, double mu, double beta) {
        return mu - beta * FastMath.log(-FastMath.log(val));
    }

    @Override
    public double quantile(double val) {
        return GumbelDistribution.quantile(val, this.mu, this.beta);
    }

    @Override
    public double nextRandom() {
        return this.mu - this.beta * FastMath.log(-FastMath.log(this.random.nextDouble()));
    }

    @Override
    public String toString() {
        return "GumbelDistribution(mu=" + this.mu + ", beta=" + this.beta + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double mean;
        double shape;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter shapeP;
            super.makeOptions(config);
            DoubleParameter meanP = new DoubleParameter(LOCATION_ID);
            if (config.grab(meanP)) {
                this.mean = meanP.doubleValue();
            }
            if (config.grab(shapeP = new DoubleParameter(SHAPE_ID))) {
                this.shape = shapeP.doubleValue();
            }
        }

        @Override
        protected GumbelDistribution makeInstance() {
            return new GumbelDistribution(this.mean, this.shape, this.rnd);
        }
    }
}

