/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.Primes;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.UniformDistribution;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

@Reference(title="Randomized halton sequences", authors="X. Wang, F. J. Hickernell", booktitle="Mathematical and Computer Modelling Vol. 32 (7)", url="https://doi.org/10.1016/S0895-7177(00)00178-3", bibkey="doi:10.1016/S0895-71770000178-3")
public class HaltonUniformDistribution
implements Distribution {
    private double min;
    private double max;
    private double len;
    private static final int MAXFAST = 1000;
    private static final double ALMOST_ONE = 0.9999999999;
    final short base;
    final double invbase;
    final double logbase;
    final int maxi;
    int counter = 0;
    double current;
    long inverse;

    public HaltonUniformDistribution(double min, double max, int base, double seed) {
        if (min > max) {
            double tmp = min;
            min = max;
            max = tmp;
        }
        this.min = min;
        this.max = max;
        this.len = max - min;
        this.base = (short)base;
        this.invbase = 1.0 / (double)base;
        this.logbase = FastMath.log(base);
        this.maxi = (int)(32.0 * MathUtil.LOG2 / this.logbase);
        this.current = seed;
        this.inverse = this.inverse(seed);
    }

    public HaltonUniformDistribution(double min, double max) {
        this(min, max, new Random());
    }

    public HaltonUniformDistribution(double min, double max, Random rnd) {
        this(min, max, HaltonUniformDistribution.choosePrime(rnd), rnd.nextDouble());
    }

    public HaltonUniformDistribution(double min, double max, RandomFactory rnd) {
        this(min, max, rnd.getRandom());
    }

    private static int choosePrime(Random rnd) {
        return Primes.FIRST_PRIMES[rnd.nextInt(10)];
    }

    @Override
    public double pdf(double val) {
        return !(val >= this.min) || val > this.max ? (val == val ? 0.0 : Double.NaN) : (this.len > 0.0 ? 1.0 / this.len : Double.POSITIVE_INFINITY);
    }

    @Override
    public double logpdf(double val) {
        return !(val >= this.min) || val > this.max ? (val == val ? Double.NEGATIVE_INFINITY : Double.NaN) : (this.len > 0.0 ? FastMath.log(1.0 / this.len) : Double.POSITIVE_INFINITY);
    }

    @Override
    public double cdf(double val) {
        return !(val > this.min) ? (val == val ? 0.0 : Double.NaN) : (val >= this.max ? 1.0 : (this.len > 0.0 ? (val - this.min) / this.len : 0.5));
    }

    @Override
    public double quantile(double val) {
        return val >= 0.0 && val <= 1.0 ? this.min + this.len * val : Double.NaN;
    }

    private long inverse(double current) {
        short[] digits = new short[this.maxi];
        for (int j = 0; j < this.maxi; ++j) {
            digits[j] = (short)(current *= (double)this.base);
            if ((current -= (double)digits[j]) <= 1.0E-10) break;
        }
        long inv = 0L;
        for (int j = this.maxi - 1; j >= 0; --j) {
            inv = inv * (long)this.base + (long)digits[j];
        }
        return inv;
    }

    private double radicalInverse(long i) {
        double digit;
        double radical = digit = 1.0 / (double)this.base;
        double inverse = 0.0;
        while (i > 0L) {
            inverse += digit * (double)(i % (long)this.base);
            digit *= radical;
            i /= (long)this.base;
        }
        return inverse;
    }

    private double nextRadicalInverse() {
        ++this.counter;
        if (this.counter >= 1000) {
            this.counter = 0;
            this.inverse += 1000L;
            this.current = this.radicalInverse(this.inverse);
            return this.current;
        }
        double nextInverse = this.current + this.invbase;
        if (nextInverse < 0.9999999999) {
            this.current = nextInverse;
            return this.current;
        }
        double digit1 = this.invbase;
        double digit2 = this.invbase * this.invbase;
        while (this.current + digit2 >= 0.9999999999) {
            digit1 = digit2;
            digit2 *= this.invbase;
        }
        this.current += digit1 - 1.0 + digit2;
        return this.current;
    }

    @Override
    public double nextRandom() {
        return this.min + this.nextRadicalInverse() * this.len;
    }

    @Override
    public String toString() {
        return "HaltonUniformDistribution(min=" + this.min + ", max=" + this.max + ")";
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double min;
        double max;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter maxP;
            super.makeOptions(config);
            DoubleParameter minP = new DoubleParameter(UniformDistribution.Parameterizer.MIN_ID);
            if (config.grab(minP)) {
                this.min = minP.doubleValue();
            }
            if (config.grab(maxP = new DoubleParameter(UniformDistribution.Parameterizer.MAX_ID))) {
                this.max = maxP.doubleValue();
            }
        }

        @Override
        protected HaltonUniformDistribution makeInstance() {
            return new HaltonUniformDistribution(this.min, this.max, this.rnd);
        }
    }
}

