/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

@Alias(value={"invgauss", "wald", "de.lmu.ifi.dbs.elki.math.statistics.distribution.WaldDistribution"})
public class InverseGaussianDistribution
extends AbstractDistribution {
    private double mean;
    private double shape;

    public InverseGaussianDistribution(double mean, double shape, Random random) {
        super(random);
        this.mean = mean;
        this.shape = shape;
    }

    public InverseGaussianDistribution(double mean, double shape, RandomFactory random) {
        super(random);
        this.mean = mean;
        this.shape = shape;
    }

    public InverseGaussianDistribution(double mean, double shape) {
        this(mean, shape, (Random)null);
    }

    public double getMean() {
        return this.mean;
    }

    public double getShape() {
        return this.shape;
    }

    @Override
    public double pdf(double val) {
        return InverseGaussianDistribution.pdf(val, this.mean, this.shape);
    }

    @Override
    public double logpdf(double val) {
        return InverseGaussianDistribution.logpdf(val, this.mean, this.shape);
    }

    @Override
    public double cdf(double val) {
        return InverseGaussianDistribution.cdf(val, this.mean, this.shape);
    }

    @Override
    @Deprecated
    public double quantile(double q) {
        return InverseGaussianDistribution.quantile(q, this.mean, this.shape);
    }

    @Override
    public double nextRandom() {
        double v = this.random.nextGaussian();
        v *= v;
        double x = this.mean + this.mean * 0.5 / this.shape * (this.mean * v - FastMath.sqrt(4.0 * this.mean * this.shape * v + this.mean * this.mean * v * v));
        double u = this.random.nextDouble();
        if (u * (this.mean + x) <= this.mean) {
            return x;
        }
        return this.mean * this.mean / x;
    }

    @Override
    public String toString() {
        return "WaldDistribution(mean=" + this.mean + ", shape=" + this.shape + ")";
    }

    public static double pdf(double x, double mu, double shape) {
        if (!(x > 0.0) || x == Double.POSITIVE_INFINITY) {
            return x == x ? 0.0 : Double.NaN;
        }
        double v = (x - mu) / mu;
        double t1 = FastMath.sqrt(shape / (Math.PI * 2 * x * x * x));
        return t1 > 0.0 ? t1 * FastMath.exp(-shape * v * v * 0.5 / x) : 0.0;
    }

    public static double logpdf(double x, double mu, double shape) {
        if (!(x > 0.0) || x == Double.POSITIVE_INFINITY) {
            return x == x ? Double.NEGATIVE_INFINITY : Double.NaN;
        }
        double v = (x - mu) / mu;
        return v < Double.MAX_VALUE ? 0.5 * FastMath.log(shape / (Math.PI * 2 * x * x * x)) - shape * v * v / (2.0 * x) : Double.NEGATIVE_INFINITY;
    }

    public static double cdf(double x, double mu, double shape) {
        if (!(x > 0.0)) {
            return x == x ? 0.0 : Double.NaN;
        }
        double v0 = x / mu;
        double v1 = FastMath.sqrt(shape / x);
        if (v1 == 0.0) {
            return v0 > 0.0 ? 1.0 : 0.0;
        }
        double c1 = NormalDistribution.standardNormalCDF(v1 * (v0 - 1.0));
        double c2 = NormalDistribution.standardNormalCDF(-v1 * (v0 + 1.0));
        return c2 > 0.0 ? c1 + FastMath.exp(2.0 * shape / mu) * c2 : c1;
    }

    @Deprecated
    public static double quantile(double x, double mu, double shape) {
        throw new NotImplementedException();
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double mean;
        double shape;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter shapeP;
            super.makeOptions(config);
            DoubleParameter meanP = new DoubleParameter(LOCATION_ID);
            if (config.grab(meanP)) {
                this.mean = meanP.doubleValue();
            }
            if (config.grab(shapeP = new DoubleParameter(SHAPE_ID))) {
                this.shape = shapeP.doubleValue();
            }
        }

        @Override
        protected InverseGaussianDistribution makeInstance() {
            return new InverseGaussianDistribution(this.mean, this.shape, this.rnd);
        }
    }
}

