/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class KappaDistribution
extends AbstractDistribution {
    double location;
    double scale;
    double shape1;
    double shape2;

    public KappaDistribution(double location, double scale, double shape1, double shape2) {
        this(location, scale, shape1, shape2, (Random)null);
    }

    public KappaDistribution(double location, double scale, double shape1, double shape2, Random random) {
        super(random);
        this.location = location;
        this.scale = scale;
        this.shape1 = shape1;
        this.shape2 = shape2;
        if (shape2 >= 0.0) {
            if (shape1 < -1.0) {
                throw new ArithmeticException("Invalid shape1 parameter - must be greater than -1 if shape2 >= 0.!");
            }
        } else if (shape1 != 0.0 && (shape1 < 1.0 || shape1 > 1.0 / shape2)) {
            throw new ArithmeticException("Invalid shape1 parameter - must be -1 to +1/shape2 if shape2 < 0.!");
        }
    }

    public KappaDistribution(double location, double scale, double shape1, double shape2, RandomFactory random) {
        super(random);
        this.location = location;
        this.scale = scale;
        this.shape1 = shape1;
        this.shape2 = shape2;
        if (shape2 >= 0.0) {
            if (shape1 < -1.0) {
                throw new ArithmeticException("Invalid shape1 parameter - must be greater than -1 if shape2 >= 0.!");
            }
        } else if (shape1 < 1.0 || shape1 > 1.0 / shape2) {
            throw new ArithmeticException("Invalid shape1 parameter - must be -1 to +1/shape2 if shape2 < 0.!");
        }
    }

    public static double pdf(double val, double loc, double scale, double shape1, double shape2) {
        val = (val - loc) / scale;
        double logc = KappaDistribution.logcdf(val, shape1, shape2);
        if (shape1 == 1.0) {
            return val >= 1.0 ? 0.0 : FastMath.exp(logc * (1.0 - shape2)) / scale;
        }
        if (shape1 != 0.0) {
            if ((val = shape1 * val) >= 1.0) {
                return 0.0;
            }
            val = (1.0 - 1.0 / shape1) * FastMath.log1p(-val);
        }
        if (Double.isInfinite(val)) {
            return 0.0;
        }
        return Double.isInfinite(val = FastMath.exp(-val)) ? 0.0 : val / scale * FastMath.exp(logc * (1.0 - shape2));
    }

    @Override
    public double pdf(double val) {
        return KappaDistribution.pdf(val, this.location, this.scale, this.shape1, this.shape2);
    }

    public static double logpdf(double val, double loc, double scale, double shape1, double shape2) {
        val = (val - loc) / scale;
        double logc = KappaDistribution.logcdf(val, shape1, shape2);
        if (shape1 != 0.0) {
            if ((val = shape1 * val) >= 1.0) {
                return Double.NEGATIVE_INFINITY;
            }
            val = (1.0 - 1.0 / shape1) * FastMath.log1p(-val);
        }
        if (Double.isInfinite(val)) {
            return Double.NEGATIVE_INFINITY;
        }
        return -val - FastMath.log(scale) + logc * (1.0 - shape2);
    }

    @Override
    public double logpdf(double val) {
        return KappaDistribution.logpdf(val, this.location, this.scale, this.shape1, this.shape2);
    }

    public static double cdf(double val, double loc, double scale, double shape1, double shape2) {
        double tmp;
        if ((val = (val - loc) / scale) == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (val == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (val != val) {
            return Double.NaN;
        }
        if (shape1 == 0.0) {
            val = FastMath.exp(-val);
        } else {
            tmp = shape1 * val;
            if (tmp == Double.NEGATIVE_INFINITY) {
                return shape2 == 0.0 ? 1.0 : 0.0;
            }
            if (tmp >= 1.0) {
                return shape2 == 0.0 ? 0.0 : 1.0;
            }
            val = FastMath.exp(FastMath.log1p(-tmp) / shape1);
        }
        if (shape2 == 0.0) {
            return FastMath.exp(-val);
        }
        tmp = shape2 * val;
        return tmp < 1.0 ? FastMath.exp(FastMath.log1p(-tmp) / shape2) : 0.0;
    }

    public static double logcdf(double val, double loc, double scale, double shape1, double shape2) {
        return KappaDistribution.logcdf((val - loc) / scale, shape1, shape2);
    }

    public static double logcdf(double val, double shape1, double shape2) {
        double tmp;
        if (val == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (val == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        if (val != val) {
            return Double.NaN;
        }
        if (shape1 == 0.0) {
            val = FastMath.exp(-val);
        } else {
            tmp = shape1 * val;
            if (tmp == Double.NEGATIVE_INFINITY) {
                return shape2 == 0.0 ? 0.0 : Double.NEGATIVE_INFINITY;
            }
            if (tmp >= 1.0) {
                return shape2 == 0.0 ? Double.NEGATIVE_INFINITY : 0.0;
            }
            val = FastMath.exp(FastMath.log1p(-tmp) / shape1);
        }
        if (shape2 == 0.0) {
            return -val;
        }
        tmp = shape2 * val;
        return tmp < 1.0 ? FastMath.log1p(-tmp) / shape2 : Double.NEGATIVE_INFINITY;
    }

    @Override
    public double cdf(double val) {
        return KappaDistribution.cdf(val, this.location, this.scale, this.shape1, this.shape2);
    }

    public static double quantile(double val, double loc, double scale, double shape1, double shape2) {
        if (!(val >= 0.0) || !(val <= 1.0)) {
            return Double.NaN;
        }
        if (val == 0.0) {
            if (shape2 <= 0.0) {
                return shape1 < 0.0 ? loc + scale / shape1 : Double.NEGATIVE_INFINITY;
            }
            return loc + (shape1 != 0.0 ? scale / shape1 * (1.0 - FastMath.pow(shape2, -shape1)) : scale * FastMath.log(shape2));
        }
        if (val == 1.0) {
            return shape1 <= 0.0 ? Double.NEGATIVE_INFINITY : loc + scale / shape1;
        }
        val = -FastMath.log(val);
        if (shape2 != 0.0) {
            val = (1.0 - FastMath.exp(-shape2 * val)) / shape2;
        }
        val = -FastMath.log(val);
        if (shape1 != 0.0) {
            val = (1.0 - FastMath.exp(-shape1 * val)) / shape1;
        }
        return loc + scale * val;
    }

    @Override
    public double quantile(double val) {
        return KappaDistribution.quantile(val, this.location, this.scale, this.shape1, this.shape2);
    }

    @Override
    public double nextRandom() {
        return KappaDistribution.quantile(this.random.nextDouble(), this.location, this.scale, this.shape1, this.shape2);
    }

    @Override
    public String toString() {
        return "KappaDistribution(location=" + this.location + ", scale=" + this.scale + ", shape1=" + this.shape1 + ", shape2=" + this.shape2 + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID SHAPE1_ID = new OptionID("distribution.kappa.shape1", "First shape parameter of kappa distribution.");
        public static final OptionID SHAPE2_ID = new OptionID("distribution.kappa.shape2", "Second shape parameter of kappa distribution.");
        double location;
        double scale;
        double shape1;
        double shape2;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter shape2P;
            DoubleParameter shape1P;
            DoubleParameter scaleP;
            super.makeOptions(config);
            DoubleParameter locationP = new DoubleParameter(LOCATION_ID);
            if (config.grab(locationP)) {
                this.location = locationP.doubleValue();
            }
            if (config.grab(scaleP = new DoubleParameter(SCALE_ID))) {
                this.scale = scaleP.doubleValue();
            }
            if (config.grab(shape1P = new DoubleParameter(SHAPE1_ID))) {
                this.shape1 = shape1P.doubleValue();
            }
            if (config.grab(shape2P = new DoubleParameter(SHAPE2_ID))) {
                this.shape2 = shape2P.doubleValue();
            }
        }

        @Override
        protected KappaDistribution makeInstance() {
            return new KappaDistribution(this.location, this.scale, this.shape1, this.shape2, this.rnd);
        }
    }
}

