/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

@Alias(value={"DoubleExponentialDistribution"})
public class LaplaceDistribution
extends AbstractDistribution {
    double rate;
    double location;

    public LaplaceDistribution(double rate) {
        this(rate, 0.0, (Random)null);
    }

    public LaplaceDistribution(double rate, double location) {
        this(rate, location, (Random)null);
    }

    public LaplaceDistribution(double rate, Random random) {
        this(rate, 0.0, random);
    }

    public LaplaceDistribution(double rate, double location, Random random) {
        super(random);
        this.rate = rate;
        this.location = location;
    }

    public LaplaceDistribution(double rate, double location, RandomFactory random) {
        super(random);
        this.rate = rate;
        this.location = location;
    }

    public double getRate() {
        return this.rate;
    }

    public double getLocation() {
        return this.location;
    }

    @Override
    public double pdf(double val) {
        return 0.5 * this.rate * FastMath.exp(-this.rate * Math.abs(val - this.location));
    }

    public static double pdf(double val, double rate) {
        return 0.5 * rate * FastMath.exp(-rate * Math.abs(val));
    }

    @Override
    public double logpdf(double val) {
        return FastMath.log(0.5 * this.rate) - this.rate * Math.abs(val - this.location);
    }

    public static double logpdf(double val, double rate) {
        return FastMath.log(0.5 * rate) - rate * Math.abs(val);
    }

    @Override
    public double cdf(double val) {
        return LaplaceDistribution.cdf(val - this.location, this.rate);
    }

    public static double cdf(double val, double rate) {
        double v = 0.5 * FastMath.exp(-rate * Math.abs(val));
        return v == Double.POSITIVE_INFINITY ? (double)(!(val <= 0.0) ? 1 : 0) : (val < 0.0 ? v : 1.0 - v);
    }

    @Override
    public double quantile(double val) {
        if (val < 0.5) {
            return FastMath.log(2.0 * val) / this.rate + this.location;
        }
        return -FastMath.log(2.0 - 2.0 * val) / this.rate + this.location;
    }

    public static double quantile(double val, double rate, double location) {
        if (val < 0.5) {
            return FastMath.log(2.0 * val) / rate + location;
        }
        return -FastMath.log(2.0 - 2.0 * val) / rate + location;
    }

    @Override
    public double nextRandom() {
        double val = this.random.nextDouble();
        if (val < 0.5) {
            return FastMath.log(2.0 * val) / this.rate + this.location;
        }
        return -FastMath.log(2.0 - 2.0 * val) / this.rate + this.location;
    }

    @Override
    public String toString() {
        return "LaplaceDistribution(rate=" + this.rate + ", location=" + this.location + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID RATE_ID = new OptionID("distribution.laplace.rate", "Laplace distribution rate (lambda) parameter (inverse of scale).");
        double location;
        double rate;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter rateP;
            super.makeOptions(config);
            DoubleParameter locP = new DoubleParameter(LOCATION_ID);
            if (config.grab(locP)) {
                this.location = locP.doubleValue();
            }
            if (config.grab(rateP = new DoubleParameter(RATE_ID))) {
                this.rate = rateP.doubleValue();
            }
        }

        @Override
        protected LaplaceDistribution makeInstance() {
            return new LaplaceDistribution(this.rate, this.location, this.rnd);
        }
    }
}

