/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class LogGammaDistribution
extends AbstractDistribution {
    private final double k;
    private final double theta;
    private final double shift;

    public LogGammaDistribution(double k, double theta, double shift, Random random) {
        super(random);
        if (!(k > 0.0) || !(theta > 0.0)) {
            throw new IllegalArgumentException("Invalid parameters for Gamma distribution: " + k + " " + theta);
        }
        this.k = k;
        this.theta = theta;
        this.shift = shift;
    }

    public LogGammaDistribution(double k, double theta, double shift, RandomFactory random) {
        super(random);
        if (!(k > 0.0) || !(theta > 0.0)) {
            throw new IllegalArgumentException("Invalid parameters for Gamma distribution: " + k + " " + theta);
        }
        this.k = k;
        this.theta = theta;
        this.shift = shift;
    }

    public LogGammaDistribution(double k, double theta, double shift) {
        this(k, theta, shift, (Random)null);
    }

    @Override
    public double pdf(double val) {
        return LogGammaDistribution.pdf(val, this.k, this.theta, this.shift);
    }

    @Override
    public double logpdf(double val) {
        return LogGammaDistribution.logpdf(val, this.k, this.theta, this.shift);
    }

    @Override
    public double cdf(double val) {
        return LogGammaDistribution.cdf(val, this.k, this.theta, this.shift);
    }

    @Override
    public double quantile(double val) {
        return LogGammaDistribution.quantile(val, this.k, this.theta, this.shift);
    }

    @Override
    public double nextRandom() {
        return FastMath.exp(GammaDistribution.nextRandom(this.k, this.theta, this.random)) + this.shift;
    }

    @Override
    public String toString() {
        return "LogGammaDistribution(k=" + this.k + ", theta=" + this.theta + ", shift=" + this.shift + ")";
    }

    public double getK() {
        return this.k;
    }

    public double getTheta() {
        return this.theta;
    }

    public static double cdf(double x, double k, double theta, double shift) {
        return (x -= shift) <= 0.0 ? 0.0 : GammaDistribution.regularizedGammaP(k, FastMath.log1p(x) * theta);
    }

    public static double logcdf(double x, double k, double theta, double shift) {
        return (x -= shift) <= 0.0 ? Double.POSITIVE_INFINITY : GammaDistribution.logregularizedGammaP(k, FastMath.log1p(x) * theta);
    }

    public static double pdf(double x, double k, double theta, double shift) {
        return (x -= shift) <= 0.0 ? 0.0 : FastMath.pow(theta, k) / GammaDistribution.gamma(k) * FastMath.pow(1.0 + x, -(theta + 1.0)) * FastMath.pow(FastMath.log1p(x), k - 1.0);
    }

    public static double logpdf(double x, double k, double theta, double shift) {
        if ((x -= shift) <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double log1px = FastMath.log1p(x);
        return k * FastMath.log(theta) - GammaDistribution.logGamma(k) - (theta + 1.0) * log1px + (k - 1.0) * FastMath.log(log1px);
    }

    public static double quantile(double p, double k, double theta, double shift) {
        return FastMath.exp(GammaDistribution.quantile(p, k, theta)) + shift;
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID SHIFT_ID = new OptionID("distribution.loggamma.shift", "Shift offset parameter.");
        double k;
        double theta;
        double shift;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter shiftP;
            DoubleParameter thetaP;
            super.makeOptions(config);
            DoubleParameter kP = new DoubleParameter(GammaDistribution.Parameterizer.K_ID);
            if (config.grab(kP)) {
                this.k = kP.doubleValue();
            }
            if (config.grab(thetaP = new DoubleParameter(GammaDistribution.Parameterizer.THETA_ID))) {
                this.theta = thetaP.doubleValue();
            }
            if (config.grab(shiftP = new DoubleParameter(SHIFT_ID))) {
                this.shift = shiftP.doubleValue();
            }
        }

        @Override
        protected LogGammaDistribution makeInstance() {
            return new LogGammaDistribution(this.k, this.theta, this.shift, this.rnd);
        }
    }
}

