/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

@Alias(value={"fisk", "loglog"})
public class LogLogisticDistribution
extends AbstractDistribution {
    double scale;
    double location;
    double shape;

    public LogLogisticDistribution(double shape, double location, double scale) {
        this(shape, location, scale, (Random)null);
    }

    public LogLogisticDistribution(double shape, double location, double scale, Random random) {
        super(random);
        this.shape = shape;
        this.scale = scale;
        this.location = location;
    }

    public LogLogisticDistribution(double shape, double location, double scale, RandomFactory random) {
        super(random);
        this.shape = shape;
        this.scale = scale;
        this.location = location;
    }

    public double getShape() {
        return this.shape;
    }

    public double getLocation() {
        return this.location;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double pdf(double val) {
        return LogLogisticDistribution.pdf(val, this.shape, this.location, this.scale);
    }

    public static double pdf(double val, double shape, double location, double scale) {
        if (val < location) {
            return 0.0;
        }
        double f = shape / scale * FastMath.pow(val = (val - location) / scale, shape - 1.0);
        if (f == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        double d = 1.0 + FastMath.pow(val, shape);
        return f / (d * d);
    }

    @Override
    public double logpdf(double val) {
        return LogLogisticDistribution.logpdf(val, this.shape, this.location, this.scale);
    }

    public static double logpdf(double val, double shape, double location, double scale) {
        if (val < location) {
            return Double.NEGATIVE_INFINITY;
        }
        double lval = FastMath.log(val = (val - location) / scale);
        if (lval == Double.POSITIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        return FastMath.log(shape / scale) + (shape - 1.0) * lval - 2.0 * FastMath.log1p(FastMath.exp(lval * shape));
    }

    @Override
    public double cdf(double val) {
        return LogLogisticDistribution.cdf(val, this.shape, this.location, this.scale);
    }

    public static double cdf(double val, double shape, double location, double scale) {
        if (val < location) {
            return 0.0;
        }
        val = (val - location) / scale;
        return 1.0 / (1.0 + FastMath.pow(val, -shape));
    }

    @Override
    public double quantile(double val) {
        return LogLogisticDistribution.quantile(val, this.shape, this.location, this.scale);
    }

    public static double quantile(double val, double shape, double location, double scale) {
        return val < 0.0 || val > 1.0 ? Double.NaN : scale * FastMath.pow(val / (1.0 - val), 1.0 / shape) + location;
    }

    @Override
    public double nextRandom() {
        double u = this.random.nextDouble();
        return this.scale * FastMath.pow(u / (1.0 - u), 1.0 / this.shape) + this.location;
    }

    @Override
    public String toString() {
        return "LogLogisticDistribution(shape=" + this.shape + ", location=" + this.location + ", scale=" + this.scale + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double shape;
        double location;
        double scale;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter scaleP;
            DoubleParameter locationP;
            super.makeOptions(config);
            DoubleParameter shapeP = new DoubleParameter(SHAPE_ID);
            if (config.grab(shapeP)) {
                this.shape = shapeP.doubleValue();
            }
            if (config.grab(locationP = new DoubleParameter(LOCATION_ID, 0.0))) {
                this.location = locationP.doubleValue();
            }
            if (config.grab(scaleP = new DoubleParameter(SCALE_ID, 1.0))) {
                this.scale = scaleP.doubleValue();
            }
        }

        @Override
        protected LogLogisticDistribution makeInstance() {
            return new LogLogisticDistribution(this.shape, this.location, this.scale, this.rnd);
        }
    }
}

