/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

@Alias(value={"lognormal"})
public class LogNormalDistribution
extends AbstractDistribution {
    private double logmean;
    private double logstddev;
    private double shift = 0.0;

    public LogNormalDistribution(double logmean, double logstddev, double shift, Random random) {
        super(random);
        this.logmean = logmean;
        this.logstddev = logstddev;
        this.shift = shift;
    }

    public LogNormalDistribution(double logmean, double logstddev, double shift, RandomFactory random) {
        super(random);
        this.logmean = logmean;
        this.logstddev = logstddev;
        this.shift = shift;
    }

    public LogNormalDistribution(double logmean, double logstddev, double shift) {
        this(logmean, logstddev, shift, (Random)null);
    }

    public double getLogMean() {
        return this.logmean;
    }

    public double getLogStddev() {
        return this.logstddev;
    }

    public double getShift() {
        return this.shift;
    }

    @Override
    public double pdf(double val) {
        return LogNormalDistribution.pdf(val - this.shift, this.logmean, this.logstddev);
    }

    @Override
    public double logpdf(double val) {
        return LogNormalDistribution.logpdf(val - this.shift, this.logmean, this.logstddev);
    }

    @Override
    public double cdf(double val) {
        return LogNormalDistribution.cdf(val - this.shift, this.logmean, this.logstddev);
    }

    @Override
    public double quantile(double val) {
        return LogNormalDistribution.quantile(val, this.logmean, this.logstddev) + this.shift;
    }

    public static double pdf(double x, double mu, double sigma) {
        if (x <= 0.0) {
            return 0.0;
        }
        double xrel = (FastMath.log(x) - mu) / sigma;
        return 1.0 / (MathUtil.SQRTTWOPI * sigma * x) * FastMath.exp(-0.5 * xrel * xrel);
    }

    public static double logpdf(double x, double mu, double sigma) {
        if (x <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double xrel = (FastMath.log(x) - mu) / sigma;
        return MathUtil.LOG_ONE_BY_SQRTTWOPI - FastMath.log(sigma * x) - 0.5 * xrel * xrel;
    }

    public static double cdf(double x, double mu, double sigma) {
        if (x <= 0.0) {
            return 0.0;
        }
        return 0.5 * (1.0 + NormalDistribution.erf((FastMath.log(x) - mu) / (MathUtil.SQRT2 * sigma)));
    }

    public static double quantile(double x, double mu, double sigma) {
        return FastMath.exp(mu + sigma * NormalDistribution.standardNormalQuantile(x));
    }

    @Override
    public double nextRandom() {
        return FastMath.exp(this.logmean + this.random.nextGaussian() * this.logstddev) + this.shift;
    }

    @Override
    public String toString() {
        return "LogNormalDistribution(logmean=" + this.logmean + ", logstddev=" + this.logstddev + ", shift=" + this.shift + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID LOGMEAN_ID = new OptionID("distribution.lognormal.logmean", "Mean of the distribution before logscaling.");
        public static final OptionID LOGSTDDEV_ID = new OptionID("distribution.lognormal.logstddev", "Standard deviation of the distribution before logscaling.");
        public static final OptionID SHIFT_ID = new OptionID("distribution.lognormal.shift", "Shifting offset, so the distribution does not begin at 0.");
        double shift;
        double logmean;
        double logsigma;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter shiftP;
            DoubleParameter logsigmaP;
            super.makeOptions(config);
            DoubleParameter logmeanP = new DoubleParameter(LOGMEAN_ID);
            if (config.grab(logmeanP)) {
                this.logmean = logmeanP.doubleValue();
            }
            if (config.grab(logsigmaP = (DoubleParameter)new DoubleParameter(LOGSTDDEV_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.logsigma = logsigmaP.doubleValue();
            }
            if (config.grab(shiftP = new DoubleParameter(SHIFT_ID, 0.0))) {
                this.shift = shiftP.doubleValue();
            }
        }

        @Override
        protected LogNormalDistribution makeInstance() {
            return new LogNormalDistribution(this.logmean, this.logsigma, this.shift, this.rnd);
        }
    }
}

