/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

@Alias(value={"log"})
public class LogisticDistribution
extends AbstractDistribution {
    double location;
    double scale;

    public LogisticDistribution(double location, double scale) {
        this(location, scale, (Random)null);
    }

    public LogisticDistribution(double location, double scale, Random random) {
        super(random);
        this.location = location;
        this.scale = scale;
    }

    public LogisticDistribution(double location, double scale, RandomFactory random) {
        super(random);
        this.location = location;
        this.scale = scale;
    }

    public double getLocation() {
        return this.location;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double pdf(double val) {
        return LogisticDistribution.pdf(val, this.location, this.scale);
    }

    public static double pdf(double val, double loc, double scale) {
        val = Math.abs((val - loc) / scale);
        double e = FastMath.exp(-val);
        double f = 1.0 + e;
        return e / (scale * f * f);
    }

    @Override
    public double logpdf(double val) {
        return LogisticDistribution.logpdf(val, this.location, this.scale);
    }

    public static double logpdf(double val, double loc, double scale) {
        val = Math.abs((val - loc) / scale);
        double f = 1.0 + FastMath.exp(-val);
        return -val - FastMath.log(scale * f * f);
    }

    @Override
    public double cdf(double val) {
        return LogisticDistribution.cdf(val, this.location, this.scale);
    }

    public static double cdf(double val, double loc, double scale) {
        val = (val - loc) / scale;
        return 1.0 / (1.0 + FastMath.exp(-val));
    }

    public static double logcdf(double val, double loc, double scale) {
        if ((val = (val - loc) / scale) <= 18.0) {
            return -FastMath.log1p(FastMath.exp(-val));
        }
        if (val > 33.3) {
            return val;
        }
        return val - FastMath.exp(val);
    }

    public static double quantile(double val, double loc, double scale) {
        return loc + scale * FastMath.log(val / (1.0 - val));
    }

    public static double logquantile(double val, double loc, double scale) {
        return loc + scale * (val - MathUtil.log1mexp(-val));
    }

    @Override
    public double quantile(double val) {
        return LogisticDistribution.quantile(val, this.location, this.scale);
    }

    @Override
    public double nextRandom() {
        double u = this.random.nextDouble();
        return this.location + this.scale * FastMath.log(u / (1.0 - u));
    }

    @Override
    public String toString() {
        return "LogisticDistribution(location=" + this.location + ", scale=" + this.scale + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double location;
        double scale;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter locationP;
            super.makeOptions(config);
            DoubleParameter scaleP = new DoubleParameter(SCALE_ID);
            if (config.grab(scaleP)) {
                this.scale = scaleP.doubleValue();
            }
            if (config.grab(locationP = new DoubleParameter(LOCATION_ID))) {
                this.location = locationP.doubleValue();
            }
        }

        @Override
        protected LogisticDistribution makeInstance() {
            return new LogisticDistribution(this.location, this.scale, this.rnd);
        }
    }
}

