/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

@Alias(value={"GaussianDistribution", "normal", "gauss"})
public class NormalDistribution
extends AbstractDistribution {
    static final double P_LOW = 0.02425;
    static final double P_HIGH = 0.97575;
    public static final double PHIINV075 = 0.6744897501960817;
    public static final double ONEBYPHIINV075 = 1.4826022185056018;
    private double mean;
    private double stddev;
    private static final double[] ERF_COEFF1 = new double[]{5.958930743E-11, -1.13739022964E-9, 1.466005199839E-8, -1.635035446196E-7, 1.6461004480962E-6, -1.492559551950604E-5, 1.2055331122299264E-4, -8.548326981129666E-4, 0.005223977624823223, -0.026866170645077334, 0.11283791670954882, -0.3761263890318375, 1.1283791670955126, 2.372510631E-11, -4.5493253732E-10, 5.90362766598E-9, -6.642090827576E-8, 6.7595634268133E-7, -6.21188515924E-6, 5.10388300970969E-5, -3.7015410692956176E-4, 0.00233307631218881, -0.012549884771821921, 0.05657061146827042, -0.21379664776456006, 0.8427007929497149, 9.49905026E-12, -1.8310229805E-10, 2.39463074E-9, -2.721444369609E-8, 2.8045522331686E-7, -2.61830022482897E-6, 2.195455056768781E-5, -1.6358986921372656E-4, 0.0010705215356411031, -0.006082847181135901, 0.029869784652462584, -0.13055593046562267, 0.674933236039655, 3.82722073E-12, -7.421598602E-11, 9.793057408E-10, -1.126008898854E-8, 1.1775134830784E-7, -1.1199275838265E-6, 9.62023443095201E-6, -7.404402135070773E-5, 5.068999365414488E-4, -0.003075530514392729, 0.016689778925531657, -0.08548534594781312, 0.5690907664239364, 1.55296588E-12, -3.032205868E-11, 4.0424830707E-10, -4.71135111493E-9, 5.011915876293E-8, -4.8722516178974E-7, 4.30683284629395E-6, -3.445026145385764E-5, 2.4879276133931664E-4, -0.0016294094174807928, 0.009887863739323505, -0.05962426839442304, 0.49766113250947636};
    private static final double[] ERF_COEFF2 = new double[]{-2.9734388465E-10, 2.69776334046E-9, -6.40788827665E-9, -1.6678201321E-8, -2.1854388148686E-7, 2.66246030457984E-6, 1.612722157047886E-5, -2.5616361025506627E-4, 1.5380842432375364E-4, 0.00815533022524928, -0.014022836638963193, -0.19746892495383023, 0.7151172032884284, -1.951073787E-11, -3.2302692214E-10, 5.22461866919E-9, 3.42940918551E-9, -3.5772874310272E-7, 1.9999935792654E-7, 2.687044575042908E-5, -1.1843240273775776E-4, -8.099172895603227E-4, 0.006610629705022412, 0.009095309223548273, -0.20160072778491014, 0.5116969671872764, 3.147682272E-11, -4.8465972408E-10, 6.3675740242E-10, 3.377623323271E-8, -1.5451139637086E-7, -2.03340624738438E-6, 1.947204525295057E-5, 2.854147231653228E-5, -0.0010156506315220028, 0.0027118700352009566, 0.023280950354228107, -0.16725021123116876, 0.32490054966649434, 2.31936337E-11, -6.303206648E-11, -2.64888267434E-9, 2.050708040581E-8, 1.1371857327578E-7, -2.11211337219663E-6, 3.68797328322935E-6, 9.823686253424796E-5, -6.586024399045536E-4, -7.528581489523087E-4, 0.025854344242029606, -0.11637092784486193, 0.1826733677529661, -3.67789363E-12, 2.0876046746E-10, -1.93319027226E-9, -4.35953392472E-9, 1.8006992266137E-7, -7.8441223763969E-7, -6.75407647949153E-6, 8.428418334440096E-5, -1.7604388937031816E-4, -0.002397296114350716, 0.02064129023876023, -0.06905562880005864, 0.09084526782065479};

    public NormalDistribution(double mean, double stddev, RandomFactory random) {
        super(random);
        this.mean = mean;
        this.stddev = stddev;
    }

    public NormalDistribution(double mean, double stddev, Random random) {
        super(random);
        this.mean = mean;
        this.stddev = stddev;
    }

    public NormalDistribution(double mean, double stddev) {
        this(mean, stddev, (Random)null);
    }

    @Override
    public double pdf(double val) {
        return NormalDistribution.pdf(val, this.mean, this.stddev);
    }

    @Override
    public double logpdf(double val) {
        return NormalDistribution.logpdf(val, this.mean, this.stddev);
    }

    @Override
    public double cdf(double val) {
        return NormalDistribution.cdf(val, this.mean, this.stddev);
    }

    @Override
    public double quantile(double q) {
        return NormalDistribution.quantile(q, this.mean, this.stddev);
    }

    @Override
    public double nextRandom() {
        return this.mean + this.random.nextGaussian() * this.stddev;
    }

    @Override
    public String toString() {
        return "NormalDistribution(mean=" + this.mean + ", stddev=" + this.stddev + ")";
    }

    public double getMean() {
        return this.mean;
    }

    public double getStddev() {
        return this.stddev;
    }

    @Reference(authors="T. Ooura", title="Gamma / Error Functions", booktitle="", url="http://www.kurims.kyoto-u.ac.jp/~ooura/gamerf.html", bibkey="web/Ooura96")
    public static double erfc(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isInfinite(x)) {
            return x < 0.0 ? 2.0 : 0.0;
        }
        double t = 3.97886080735226 / (Math.abs(x) + 3.97886080735226);
        double u = t - 0.5;
        double y = (((((((((0.0012710976495261409 * u + 1.1931402283834095E-4) * u - 0.003963850973605135) * u - 8.707796353172959E-4) * u + 0.007736725283135267) * u + 0.003833351262648873) * u - 0.012722381378212275) * u - 0.013382364453346007) * u + 0.016131532973325226) * u + 0.039097684558848406) * u + 0.002493672000535033;
        y = ((((((((((((y * u - 0.0838864557023002) * u - 0.11946395996432542) * u + 0.016620792496936737) * u + 0.35752427444953105) * u + 0.8052764087529106) * u + 1.1890298290927332) * u + 1.3704021768233816) * u + 1.313146538310231) * u + 1.0792551515585667) * u + 0.7743681991195386) * u + 0.49016508058531844) * u + 0.2753747415973768) * t * FastMath.exp(-x * x);
        return x < 0.0 ? 2.0 - y : y;
    }

    public static double erf(double x) {
        double y;
        double w;
        double d = w = x < 0.0 ? -x : x;
        if (w < 2.2) {
            double t = w * w;
            int k = (int)t;
            t -= (double)k;
            y = ((((((((((((ERF_COEFF1[k *= 13] * t + ERF_COEFF1[k + 1]) * t + ERF_COEFF1[k + 2]) * t + ERF_COEFF1[k + 3]) * t + ERF_COEFF1[k + 4]) * t + ERF_COEFF1[k + 5]) * t + ERF_COEFF1[k + 6]) * t + ERF_COEFF1[k + 7]) * t + ERF_COEFF1[k + 8]) * t + ERF_COEFF1[k + 9]) * t + ERF_COEFF1[k + 10]) * t + ERF_COEFF1[k + 11]) * t + ERF_COEFF1[k + 12]) * w;
        } else if (w < 6.9) {
            int k = (int)w;
            double t = w - (double)k;
            k = 13 * (k - 2);
            y = (((((((((((ERF_COEFF2[k] * t + ERF_COEFF2[k + 1]) * t + ERF_COEFF2[k + 2]) * t + ERF_COEFF2[k + 3]) * t + ERF_COEFF2[k + 4]) * t + ERF_COEFF2[k + 5]) * t + ERF_COEFF2[k + 6]) * t + ERF_COEFF2[k + 7]) * t + ERF_COEFF2[k + 8]) * t + ERF_COEFF2[k + 9]) * t + ERF_COEFF2[k + 10]) * t + ERF_COEFF2[k + 11]) * t + ERF_COEFF2[k + 12];
            y *= y;
            y *= y;
            y *= y;
            y = 1.0 - y * y;
        } else if (w == w) {
            y = 1.0;
        } else {
            return Double.NaN;
        }
        return x < 0.0 ? -y : y;
    }

    @Reference(authors="T. Ooura", title="Gamma / Error Functions", booktitle="", url="http://www.kurims.kyoto-u.ac.jp/~ooura/gamerf.html", bibkey="web/Ooura96")
    public static double erfcinv(double y) {
        double z = y > 1.0 ? 2.0 - y : y;
        double w = 0.916461398268964 - FastMath.log(z);
        double u = FastMath.sqrt(w);
        double s = (FastMath.log(u) + 0.488826640273108) / w;
        double t = 1.0 / (u + 0.231729200323405);
        double x = u * (1.0 - s * (s * 0.124610454613712 + 0.5)) - ((((-0.0728846765585675 * t + 0.269999308670029) * t + 0.150689047360223) * t + 0.116065025341614) * t + 0.499999303439796) * t;
        t = 3.97886080735226 / (x + 3.97886080735226);
        u = t - 0.5;
        s = (((((((((0.0011264809618897792 * u + 1.0573929962342305E-4) * u - 0.003512871461291) * u - 7.71708358954121E-4) * u + 0.006856494260745586) * u + 0.0033972191036777586) * u - 0.011274916933250487) * u - 0.01185981170477711) * u + 0.014296198869789802) * u + 0.03464942077890999) * u + 0.002209959270121791;
        s = ((((((((((((s * u - 0.07434243572417848) * u - 0.1058721779415955) * u + 0.014729793833148512) * u + 0.3168476385201359) * u + 0.7136576358687303) * u + 1.0537502497084714) * u + 1.2144873077999523) * u + 1.1637458193156083) * u + 0.956464974744799) * u + 0.6862659482740978) * u + 0.4343974923314301) * u + 0.24404451059319093) * t - z * FastMath.exp(x * x - 0.12078223763524522);
        x += s * (x * s + 1.0);
        return y > 1.0 ? -x : x;
    }

    public static double pdf(double x, double mu, double sigma) {
        x = (x - mu) / sigma;
        return MathUtil.ONE_BY_SQRTTWOPI / sigma * FastMath.exp(-0.5 * x * x);
    }

    public static double logpdf(double x, double mu, double sigma) {
        x = (x - mu) / sigma;
        return MathUtil.LOG_ONE_BY_SQRTTWOPI - FastMath.log(sigma) - 0.5 * x * x;
    }

    public static double standardNormalLogPDF(double x) {
        return -0.5 * x * x + MathUtil.LOG_ONE_BY_SQRTTWOPI;
    }

    public static double standardNormalPDF(double x) {
        return FastMath.exp(-0.5 * x * x) * MathUtil.ONE_BY_SQRTTWOPI;
    }

    @Reference(authors="G. Marsaglia", title="Evaluating the Normal Distribution", booktitle="Journal of Statistical Software 11(4)", url="https://doi.org/10.18637/jss.v011.i04", bibkey="doi:10.18637/jss.v011.i04")
    public static double cdf(double x, double mu, double sigma) {
        double s;
        if ((x = (x - mu) / sigma) >= 8.22) {
            return 1.0;
        }
        if (x <= -8.22) {
            return 0.0;
        }
        if (x != x) {
            return Double.NaN;
        }
        double t = 0.0;
        double b = x;
        double q = x * x;
        double i = 1.0;
        for (s = x; s != t && i < 1000.0; s += (b *= q / (i += 2.0))) {
            t = s;
        }
        return 0.5 + s * FastMath.exp(-0.5 * q - 0.9189385332046728);
    }

    @Reference(authors="G. Marsaglia", title="Evaluating the Normal Distribution", booktitle="Journal of Statistical Software 11(4)", url="https://doi.org/10.18637/jss.v011.i04", bibkey="doi:10.18637/jss.v011.i04")
    public static double standardNormalCDF(double x) {
        if (x >= 8.22) {
            return 1.0;
        }
        if (x <= -8.22) {
            return 0.0;
        }
        if (x != x) {
            return Double.NaN;
        }
        double s = x;
        double t = 0.0;
        double b = x;
        double q = x * x;
        double i = 1.0;
        while (s != t) {
            t = s;
            s = t + (b *= q / (i += 2.0));
        }
        return 0.5 + s * FastMath.exp(-0.5 * q - 0.9189385332046728);
    }

    public static double quantile(double x, double mu, double sigma) {
        return mu + sigma * NormalDistribution.standardNormalQuantile(x);
    }

    public static double standardNormalQuantile(double d) {
        return d == 0.0 ? Double.NEGATIVE_INFINITY : (d == 1.0 ? Double.POSITIVE_INFINITY : (Double.isNaN(d) || d < 0.0 || d > 1.0 ? Double.NaN : MathUtil.SQRT2 * -NormalDistribution.erfcinv(2.0 * d)));
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double mu;
        double sigma;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter sigmaP;
            super.makeOptions(config);
            DoubleParameter muP = new DoubleParameter(LOCATION_ID);
            if (config.grab(muP)) {
                this.mu = muP.doubleValue();
            }
            if (config.grab(sigmaP = (DoubleParameter)new DoubleParameter(SCALE_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.sigma = sigmaP.doubleValue();
            }
        }

        @Override
        protected NormalDistribution makeInstance() {
            return new NormalDistribution(this.mu, this.sigma, this.rnd);
        }
    }
}

