/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class PoissonDistribution
extends AbstractDistribution {
    private int n;
    private double p;
    private static final double S0 = 0.08333333333333333;
    private static final double S1 = 0.002777777777777778;
    private static final double S2 = 7.936507936507937E-4;
    private static final double S3 = 5.952380952380953E-4;
    private static final double S4 = 8.417508417508417E-4;
    private static final double[] STIRLING_EXACT_ERROR = new double[]{0.0, 0.15342640972002736, 0.08106146679532726, 0.05481412105191765, 0.0413406959554093, 0.03316287351993629, 0.02767792568499834, 0.023746163656297496, 0.020790672103765093, 0.018488450532673187, 0.016644691189821193, 0.015134973221917378, 0.013876128823070748, 0.012810465242920227, 0.01189670994589177, 0.011104559758206917, 0.010411265261972096, 0.009799416126158804, 0.009255462182712733, 0.008768700134139386, 0.00833056343336287, 0.00793411456431402, 0.007573675487951841, 0.007244554301320383, 0.00694284010720953, 0.006665247032707682, 0.006408994188004207, 0.006171712263039458, 0.0059513701127588475, 0.0057462165130101155, 0.005554733551962801};

    public PoissonDistribution(int n, double p) {
        this(n, p, (Random)null);
    }

    public PoissonDistribution(int n, double p, Random random) {
        super(random);
        this.n = n;
        this.p = p;
    }

    public PoissonDistribution(int n, double p, RandomFactory random) {
        super(random);
        this.n = n;
        this.p = p;
    }

    public double pmf(int x) {
        return PoissonDistribution.pmf(x, this.n, this.p);
    }

    @Override
    public double pdf(double x) {
        return PoissonDistribution.pmf(x, this.n, this.p);
    }

    @Override
    public double logpdf(double x) {
        return FastMath.log(PoissonDistribution.pmf(x, this.n, this.p));
    }

    @Reference(title="Fast and accurate computation of binomial probabilities", authors="C. Loader", booktitle="", url="http://projects.scipy.org/scipy/raw-attachment/ticket/620/loader2000Fast.pdf", bibkey="web/Loader00")
    public static double pmf(double x, int n, double p) {
        if (x < 0.0 || x > (double)n) {
            return 0.0;
        }
        if (p <= 0.0) {
            return x == 0.0 ? 1.0 : 0.0;
        }
        if (p >= 1.0) {
            return x == (double)n ? 1.0 : 0.0;
        }
        double q = 1.0 - p;
        if (x == 0.0) {
            if (p < 0.1) {
                return FastMath.exp(-PoissonDistribution.devianceTerm(n, (double)n * q) - (double)n * p);
            }
            return FastMath.exp((double)n * FastMath.log(q));
        }
        if (x == (double)n) {
            if (p > 0.9) {
                return FastMath.exp(-PoissonDistribution.devianceTerm(n, (double)n * p) - (double)n * q);
            }
            return FastMath.exp((double)n * FastMath.log(p));
        }
        double lc = PoissonDistribution.stirlingError(n) - PoissonDistribution.stirlingError(x) - PoissonDistribution.stirlingError((double)n - x) - PoissonDistribution.devianceTerm(x, (double)n * p) - PoissonDistribution.devianceTerm((double)n - x, (double)n * q);
        double f = Math.PI * 2 * x * ((double)n - x) / (double)n;
        return FastMath.exp(lc) / FastMath.sqrt(f);
    }

    public static double logpmf(double x, int n, double p) {
        if (x < 0.0 || x > (double)n) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p <= 0.0) {
            return x == 0.0 ? 0.0 : Double.NEGATIVE_INFINITY;
        }
        if (p >= 1.0) {
            return x == (double)n ? 0.0 : Double.NEGATIVE_INFINITY;
        }
        double q = 1.0 - p;
        if (x == 0.0) {
            if (p < 0.1) {
                return -PoissonDistribution.devianceTerm(n, (double)n * q) - (double)n * p;
            }
            return (double)n * FastMath.log(q);
        }
        if (x == (double)n) {
            if (p > 0.9) {
                return -PoissonDistribution.devianceTerm(n, (double)n * p) - (double)n * q;
            }
            return (double)n * FastMath.log(p);
        }
        double lc = PoissonDistribution.stirlingError(n) - PoissonDistribution.stirlingError(x) - PoissonDistribution.stirlingError((double)n - x) - PoissonDistribution.devianceTerm(x, (double)n * p) - PoissonDistribution.devianceTerm((double)n - x, (double)n * q);
        double f = Math.PI * 2 * x * ((double)n - x) / (double)n;
        return lc - 0.5 * FastMath.log(f);
    }

    @Override
    public double cdf(double val) {
        throw new NotImplementedException();
    }

    @Override
    public double quantile(double val) {
        throw new NotImplementedException();
    }

    @Override
    public double nextRandom() {
        throw new NotImplementedException();
    }

    public static double poissonPDFm1(double x_plus_1, double lambda) {
        if (Double.isInfinite(lambda)) {
            return 0.0;
        }
        if (x_plus_1 > 1.0) {
            return PoissonDistribution.rawProbability(x_plus_1 - 1.0, lambda);
        }
        if (lambda > Math.abs(x_plus_1 - 1.0) * MathUtil.LOG2 * 1023.0 / 1.0E-14) {
            return FastMath.exp(-lambda - GammaDistribution.logGamma(x_plus_1));
        }
        return PoissonDistribution.rawProbability(x_plus_1, lambda) * (x_plus_1 / lambda);
    }

    public static double logpoissonPDFm1(double x_plus_1, double lambda) {
        if (Double.isInfinite(lambda)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x_plus_1 > 1.0) {
            return PoissonDistribution.rawLogProbability(x_plus_1 - 1.0, lambda);
        }
        if (lambda > Math.abs(x_plus_1 - 1.0) * MathUtil.LOG2 * 1023.0 / 1.0E-14) {
            return -lambda - GammaDistribution.logGamma(x_plus_1);
        }
        return PoissonDistribution.rawLogProbability(x_plus_1, lambda) + FastMath.log(x_plus_1 / lambda);
    }

    @Reference(title="Fast and accurate computation of binomial probabilities", authors="C. Loader", booktitle="", url="http://projects.scipy.org/scipy/raw-attachment/ticket/620/loader2000Fast.pdf", bibkey="web/Loader00")
    private static double stirlingError(int n) {
        if (n < 16) {
            return STIRLING_EXACT_ERROR[n << 1];
        }
        double nn = n * n;
        if (n > 500) {
            return (0.08333333333333333 - 0.002777777777777778 / nn) / (double)n;
        }
        if (n > 80) {
            return (0.08333333333333333 - (0.002777777777777778 - 7.936507936507937E-4 / nn)) / nn / (double)n;
        }
        if (n > 35) {
            return (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - 5.952380952380953E-4 / nn) / nn) / nn) / (double)n;
        }
        return (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - (5.952380952380953E-4 - 8.417508417508417E-4 / nn) / nn) / nn) / nn) / (double)n;
    }

    @Reference(title="Fast and accurate computation of binomial probabilities", authors="C. Loader", booktitle="", url="http://projects.scipy.org/scipy/raw-attachment/ticket/620/loader2000Fast.pdf", bibkey="web/Loader00")
    private static double stirlingError(double n) {
        if (n < 16.0) {
            double n2 = 2.0 * n;
            if (FastMath.floor(n2) == n2) {
                return STIRLING_EXACT_ERROR[(int)n2];
            }
            return GammaDistribution.logGamma(n + 1.0) - (n + 0.5) * FastMath.log(n) + n - MathUtil.LOGSQRTTWOPI;
        }
        double nn = n * n;
        if (n > 500.0) {
            return (0.08333333333333333 - 0.002777777777777778 / nn) / n;
        }
        if (n > 80.0) {
            return (0.08333333333333333 - (0.002777777777777778 - 7.936507936507937E-4 / nn)) / nn / n;
        }
        if (n > 35.0) {
            return (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - 5.952380952380953E-4 / nn) / nn) / nn) / n;
        }
        return (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - (5.952380952380953E-4 - 8.417508417508417E-4 / nn) / nn) / nn) / nn) / n;
    }

    @Reference(title="Fast and accurate computation of binomial probabilities", authors="C. Loader", booktitle="", url="http://projects.scipy.org/scipy/raw-attachment/ticket/620/loader2000Fast.pdf", bibkey="web/Loader00")
    private static double devianceTerm(double x, double np) {
        if (Math.abs(x - np) < 0.1 * (x + np)) {
            double v = (x - np) / (x + np);
            double s = (x - np) * v;
            double ej = 2.0 * x * v;
            int j = 1;
            while (true) {
                double s1;
                if ((s1 = s + (ej *= v * v) / (double)(2 * j + 1)) == s) {
                    return s1;
                }
                s = s1;
                ++j;
            }
        }
        return x * FastMath.log(x / np) + np - x;
    }

    public static double rawProbability(double x, double lambda) {
        if (lambda == 0.0) {
            return x == 0.0 ? 1.0 : 0.0;
        }
        if (Double.isInfinite(lambda) || x < 0.0) {
            return 0.0;
        }
        if (x <= lambda * Double.MIN_NORMAL) {
            return FastMath.exp(-lambda);
        }
        if (lambda < x * Double.MIN_NORMAL) {
            double r = -lambda + x * FastMath.log(lambda) - GammaDistribution.logGamma(x + 1.0);
            return FastMath.exp(r);
        }
        double f = Math.PI * 2 * x;
        double y = -PoissonDistribution.stirlingError(x) - PoissonDistribution.devianceTerm(x, lambda);
        return FastMath.exp(y) / FastMath.sqrt(f);
    }

    public static double rawLogProbability(double x, double lambda) {
        if (lambda == 0.0) {
            return x == 0.0 ? 1.0 : Double.NEGATIVE_INFINITY;
        }
        if (Double.isInfinite(lambda) || x < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x <= lambda * Double.MIN_NORMAL) {
            return -lambda;
        }
        if (lambda < x * Double.MIN_NORMAL) {
            return -lambda + x * FastMath.log(lambda) - GammaDistribution.logGamma(x + 1.0);
        }
        double f = Math.PI * 2 * x;
        double y = -PoissonDistribution.stirlingError(x) - PoissonDistribution.devianceTerm(x, lambda);
        return -0.5 * FastMath.log(f) + y;
    }

    @Override
    public String toString() {
        return "PoissonDistribution(n=" + this.n + ", p=" + this.p + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID N_ID = new OptionID("distribution.poisson.n", "Number of trials.");
        public static final OptionID PROB_ID = new OptionID("distribution.poisson.probability", "Success probability.");
        int n;
        double p;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter probP;
            super.makeOptions(config);
            IntParameter nP = (IntParameter)new IntParameter(N_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(nP)) {
                this.n = nP.intValue();
            }
            if (config.grab(probP = (DoubleParameter)((DoubleParameter)new DoubleParameter(PROB_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE))) {
                this.p = probP.doubleValue();
            }
        }

        @Override
        protected PoissonDistribution makeInstance() {
            return new PoissonDistribution(this.n, this.p, this.rnd);
        }
    }
}

