/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class RayleighDistribution
extends AbstractDistribution {
    double mu = 0.0;
    double sigma;

    public RayleighDistribution(double sigma) {
        this(0.0, sigma, (Random)null);
    }

    public RayleighDistribution(double mu, double sigma) {
        this(mu, sigma, (Random)null);
    }

    public RayleighDistribution(double sigma, Random random) {
        this(0.0, sigma, random);
    }

    public RayleighDistribution(double mu, double sigma, Random random) {
        super(random);
        this.mu = mu;
        this.sigma = sigma;
    }

    public RayleighDistribution(double mu, double sigma, RandomFactory random) {
        super(random);
        this.mu = mu;
        this.sigma = sigma;
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    @Override
    public double pdf(double x) {
        return RayleighDistribution.pdf(x - this.mu, this.sigma);
    }

    public static double pdf(double x, double sigma) {
        if (!(x > 0.0) || x == Double.POSITIVE_INFINITY) {
            return x == x ? 0.0 : Double.NaN;
        }
        double xs = x / sigma;
        double v = FastMath.exp(-0.5 * xs * xs);
        return v > 0.0 ? xs / sigma * v : 0.0;
    }

    @Override
    public double logpdf(double x) {
        return RayleighDistribution.logpdf(x - this.mu, this.sigma);
    }

    public static double logpdf(double x, double sigma) {
        if (!(x > 0.0) || x == Double.POSITIVE_INFINITY) {
            return x == x ? Double.NEGATIVE_INFINITY : Double.NaN;
        }
        double xs = x / sigma;
        double xs2 = xs * xs;
        return xs2 < Double.POSITIVE_INFINITY ? FastMath.log(xs / sigma) - 0.5 * xs2 : Double.NEGATIVE_INFINITY;
    }

    @Override
    public double cdf(double val) {
        return RayleighDistribution.cdf(val - this.mu, this.sigma);
    }

    public static double cdf(double x, double sigma) {
        if (x <= 0.0) {
            return 0.0;
        }
        double xs = x / sigma;
        return 1.0 - FastMath.exp(-0.5 * xs * xs);
    }

    @Override
    public double quantile(double val) {
        return this.mu + RayleighDistribution.quantile(val, this.sigma);
    }

    public static double quantile(double val, double sigma) {
        if (!(val >= 0.0) || !(val <= 1.0)) {
            return Double.NaN;
        }
        if (val == 0.0) {
            return 0.0;
        }
        if (val == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return sigma * FastMath.sqrt(-2.0 * FastMath.log(1.0 - val));
    }

    @Override
    public double nextRandom() {
        return this.mu + this.sigma * FastMath.sqrt(-2.0 * FastMath.log(this.random.nextDouble()));
    }

    @Override
    public String toString() {
        return "RayleighDistribution(mu=" + this.mu + ", sigma=" + this.sigma + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double mean;
        double scale;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter scaleP;
            super.makeOptions(config);
            DoubleParameter meanP = new DoubleParameter(LOCATION_ID, 0.0);
            if (config.grab(meanP)) {
                this.mean = meanP.doubleValue();
            }
            if (config.grab(scaleP = new DoubleParameter(SCALE_ID))) {
                this.scale = scaleP.doubleValue();
            }
        }

        @Override
        protected RayleighDistribution makeInstance() {
            return new RayleighDistribution(this.mean, this.scale, this.rnd);
        }
    }
}

