/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

@Reference(authors="J. R. M. Hosking, J. R. Wallis", title="Regional frequency analysis: an approach based on L-moments", booktitle="Regional frequency analysis: an approach based on L-moments", url="https://doi.org/10.1017/CBO9780511529443", bibkey="doi:10.1017/CBO9780511529443")
public class SkewGeneralizedNormalDistribution
extends AbstractDistribution {
    private double loc;
    private double scale;
    private double skew;

    public SkewGeneralizedNormalDistribution(double loc, double scale, double skew, Random random) {
        super(random);
        this.loc = loc;
        this.scale = scale;
        this.skew = skew;
    }

    public SkewGeneralizedNormalDistribution(double loc, double scale, double skew, RandomFactory random) {
        super(random);
        this.loc = loc;
        this.scale = scale;
        this.skew = skew;
    }

    public SkewGeneralizedNormalDistribution(double loc, double scale, double skew) {
        this(loc, scale, skew, (Random)null);
    }

    public double getLocation() {
        return this.loc;
    }

    public double getScale() {
        return this.scale;
    }

    public double getSkew() {
        return this.skew;
    }

    @Override
    public double pdf(double val) {
        return SkewGeneralizedNormalDistribution.pdf(val, this.loc, this.scale, this.skew);
    }

    @Override
    public double logpdf(double val) {
        return SkewGeneralizedNormalDistribution.logpdf(val, this.loc, this.scale, this.skew);
    }

    @Override
    public double cdf(double val) {
        return SkewGeneralizedNormalDistribution.cdf(val, this.loc, this.scale, this.skew);
    }

    @Override
    public double quantile(double q) {
        return SkewGeneralizedNormalDistribution.quantile(q, this.loc, this.scale, this.skew);
    }

    @Override
    public double nextRandom() {
        double y = this.random.nextGaussian();
        if (Math.abs(this.skew) > 0.0) {
            y = (1.0 - FastMath.exp(-this.skew * y)) / this.skew;
        }
        return this.loc + this.scale * y;
    }

    @Override
    public String toString() {
        return "SkewNormalDistribution(mean=" + this.loc + ", stddev=" + this.scale + ", skew=" + this.skew + ")";
    }

    public static double pdf(double x, double mu, double sigma, double skew) {
        if (x != x) {
            return Double.NaN;
        }
        x = (x - mu) / sigma;
        if (skew == 0.0) {
            return MathUtil.ONE_BY_SQRTTWOPI / sigma * FastMath.exp(-0.5 * x * x);
        }
        double y = -FastMath.log1p(-skew * x) / skew;
        if (y != y || y == Double.POSITIVE_INFINITY || y == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return MathUtil.ONE_BY_SQRTTWOPI / sigma * FastMath.exp(-0.5 * y * y) / (1.0 - skew * x);
    }

    public static double logpdf(double x, double mu, double sigma, double skew) {
        if (x != x) {
            return Double.NaN;
        }
        x = (x - mu) / sigma;
        if (skew == 0.0) {
            return MathUtil.LOG_ONE_BY_SQRTTWOPI - FastMath.log(sigma) - 0.5 * x * x;
        }
        double y = -FastMath.log(1.0 - skew * x) / skew;
        if (y != y || y == Double.NEGATIVE_INFINITY || y == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        return -0.5 * y * y - FastMath.log(MathUtil.ONE_BY_SQRTTWOPI * sigma * (1.0 - skew * x));
    }

    public static double cdf(double x, double mu, double sigma, double skew) {
        x = (x - mu) / sigma;
        if (Math.abs(skew) > 0.0) {
            double tmp = 1.0 - skew * x;
            if (tmp < 1.0E-15) {
                return skew < 0.0 ? 0.0 : 1.0;
            }
            x = -FastMath.log(tmp) / skew;
        }
        return 0.5 + 0.5 * NormalDistribution.erf(x * MathUtil.SQRTHALF);
    }

    public static double quantile(double x, double mu, double sigma, double skew) {
        x = NormalDistribution.standardNormalQuantile(x);
        if (Math.abs(skew) > 0.0) {
            x = (1.0 - FastMath.exp(-skew * x)) / skew;
        }
        return mu + sigma * x;
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID SKEW_ID = new OptionID("distribution.skewgnormal.skew", "Skew of the distribution.");
        double mean;
        double sigma;
        double skew;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter skewP;
            DoubleParameter sigmaP;
            super.makeOptions(config);
            DoubleParameter meanP = new DoubleParameter(LOCATION_ID);
            if (config.grab(meanP)) {
                this.mean = meanP.doubleValue();
            }
            if (config.grab(sigmaP = (DoubleParameter)new DoubleParameter(SCALE_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.sigma = sigmaP.doubleValue();
            }
            if (config.grab(skewP = new DoubleParameter(SKEW_ID))) {
                this.skew = skewP.doubleValue();
            }
        }

        @Override
        protected SkewGeneralizedNormalDistribution makeInstance() {
            return new SkewGeneralizedNormalDistribution(this.mean, this.sigma, this.skew, this.rnd);
        }
    }
}

