/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.BetaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class StudentsTDistribution
extends AbstractDistribution {
    private final int v;

    public StudentsTDistribution(int v) {
        this(v, (Random)null);
    }

    public StudentsTDistribution(int v, Random random) {
        super(random);
        this.v = v;
    }

    public StudentsTDistribution(int v, RandomFactory random) {
        super(random);
        this.v = v;
    }

    @Override
    public double pdf(double val) {
        return StudentsTDistribution.pdf(val, this.v);
    }

    @Override
    public double logpdf(double val) {
        return StudentsTDistribution.logpdf(val, this.v);
    }

    @Override
    public double cdf(double val) {
        return StudentsTDistribution.cdf(val, this.v);
    }

    @Override
    public double quantile(double val) {
        throw new NotImplementedException();
    }

    @Override
    public double nextRandom() {
        throw new NotImplementedException();
    }

    public static double pdf(double val, int v) {
        return FastMath.exp(GammaDistribution.logGamma((double)(v + 1) * 0.5) - GammaDistribution.logGamma((double)v * 0.5)) * (1.0 / FastMath.sqrt((double)v * Math.PI)) * FastMath.pow(1.0 + val * val / (double)v, -((double)(v + 1) * 0.5));
    }

    public static double logpdf(double val, int v) {
        return GammaDistribution.logGamma((double)(v + 1) * 0.5) - GammaDistribution.logGamma((double)v * 0.5) - 0.5 * FastMath.log((double)v * Math.PI) + FastMath.log1p(val * val / (double)v) * -0.5 * (double)(v + 1);
    }

    public static double cdf(double val, int v) {
        double x = (double)v / (val * val + (double)v);
        return 1.0 - 0.5 * BetaDistribution.regularizedIncBeta(x, (double)v * 0.5, 0.5);
    }

    @Override
    public String toString() {
        return "StudentsTDistribution(v=" + this.v + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID NU_ID = new OptionID("distribution.studentst.nu", "Degrees of freedom.");
        int nu;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter nuP = new IntParameter(NU_ID);
            if (config.grab(nuP)) {
                this.nu = nuP.intValue();
            }
        }

        @Override
        protected StudentsTDistribution makeInstance() {
            return new StudentsTDistribution(this.nu, this.rnd);
        }
    }
}

