/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

@Alias(value={"de.lmu.ifi.dbs.elki.data.synthetic.bymodel.distribution.UniformDistribution"})
public class UniformDistribution
extends AbstractDistribution {
    private double min;
    private double max;
    private double len;

    public UniformDistribution(double min, double max, RandomFactory random) {
        super(random);
        if (Double.isInfinite(min) || Double.isInfinite(max)) {
            throw new ArithmeticException("Infinite values given for uniform distribution.");
        }
        if (Double.isNaN(min) || Double.isNaN(max)) {
            throw new ArithmeticException("NaN values given for uniform distribution.");
        }
        if (min > max) {
            double tmp = min;
            min = max;
            max = tmp;
        }
        this.min = min;
        this.max = max;
        this.len = max - min;
    }

    public UniformDistribution(double min, double max, Random random) {
        super(random);
        if (Double.isInfinite(min) || Double.isInfinite(max)) {
            throw new ArithmeticException("Infinite values given for uniform distribution.");
        }
        if (Double.isNaN(min) || Double.isNaN(max)) {
            throw new ArithmeticException("NaN values given for uniform distribution.");
        }
        if (min > max) {
            double tmp = min;
            min = max;
            max = tmp;
        }
        this.min = min;
        this.max = max;
        this.len = max - min;
    }

    public UniformDistribution(double min, double max) {
        this(min, max, (Random)null);
    }

    @Override
    public double pdf(double val) {
        return !(val >= this.min) || val > this.max ? (val == val ? 0.0 : Double.NaN) : (this.len > 0.0 ? 1.0 / this.len : Double.POSITIVE_INFINITY);
    }

    @Override
    public double logpdf(double val) {
        return !(val >= this.min) || val > this.max ? (val == val ? Double.NEGATIVE_INFINITY : Double.NaN) : (this.len > 0.0 ? FastMath.log(1.0 / this.len) : Double.POSITIVE_INFINITY);
    }

    @Override
    public double cdf(double val) {
        return !(val > this.min) ? (val == val ? 0.0 : Double.NaN) : (val >= this.max ? 1.0 : (this.len > 0.0 ? (val - this.min) / this.len : 0.5));
    }

    @Override
    public double quantile(double val) {
        return val >= 0.0 && val <= 1.0 ? this.min + this.len * val : Double.NaN;
    }

    @Override
    public double nextRandom() {
        return this.min + this.random.nextDouble() * this.len;
    }

    @Override
    public String toString() {
        return "UniformDistribution(min=" + this.min + ", max=" + this.max + ")";
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID MIN_ID = new OptionID("distribution.min", "Minimum value of distribution.");
        public static final OptionID MAX_ID = new OptionID("distribution.max", "Maximum value of distribution.");
        double min;
        double max;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter maxP;
            super.makeOptions(config);
            DoubleParameter minP = new DoubleParameter(MIN_ID);
            if (config.grab(minP)) {
                this.min = minP.doubleValue();
            }
            if (config.grab(maxP = new DoubleParameter(MAX_ID))) {
                this.max = maxP.doubleValue();
            }
        }

        @Override
        protected UniformDistribution makeInstance() {
            return new UniformDistribution(this.min, this.max, this.rnd);
        }
    }
}

