/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class WeibullDistribution
extends AbstractDistribution {
    double theta = 0.0;
    double k;
    double lambda;

    public WeibullDistribution(double k, double lambda) {
        this(k, lambda, 0.0, (Random)null);
    }

    public WeibullDistribution(double k, double lambda, double theta) {
        this(k, lambda, theta, (Random)null);
    }

    public WeibullDistribution(double k, double lambda, Random random) {
        this(k, lambda, 0.0, random);
    }

    public WeibullDistribution(double k, double lambda, double theta, Random random) {
        super(random);
        this.k = k;
        this.lambda = lambda;
        this.theta = theta;
    }

    public WeibullDistribution(double k, double lambda, double theta, RandomFactory random) {
        super(random);
        this.k = k;
        this.lambda = lambda;
        this.theta = theta;
    }

    public double getK() {
        return this.k;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getTheta() {
        return this.theta;
    }

    @Override
    public double pdf(double x) {
        return WeibullDistribution.pdf(x, this.k, this.lambda, this.theta);
    }

    @Override
    public double logpdf(double x) {
        return WeibullDistribution.logpdf(x, this.k, this.lambda, this.theta);
    }

    public static double pdf(double x, double k, double lambda, double theta) {
        if (x <= theta || x == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        double xl = (x - theta) / lambda;
        double p = FastMath.pow(xl, k - 1.0);
        double p2 = p * -xl;
        return p2 != Double.NEGATIVE_INFINITY ? k / lambda * p * FastMath.exp(p2) : 0.0;
    }

    public static double logpdf(double x, double k, double lambda, double theta) {
        if (x <= theta || x == Double.POSITIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        double xl = (x - theta) / lambda;
        return FastMath.log(k / lambda) + (k - 1.0) * FastMath.log(xl) - FastMath.pow(xl, k);
    }

    public static double cdf(double val, double k, double lambda, double theta) {
        return val > theta ? 1.0 - FastMath.exp(-FastMath.pow((val - theta) / lambda, k)) : (val == val ? 0.0 : Double.NaN);
    }

    @Override
    public double cdf(double val) {
        return WeibullDistribution.cdf(val, this.k, this.lambda, this.theta);
    }

    public static double quantile(double val, double k, double lambda, double theta) {
        if (val < 0.0 || val > 1.0) {
            return Double.NaN;
        }
        if (val == 0.0) {
            return 0.0;
        }
        if (val == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return theta + lambda * FastMath.pow(-FastMath.log(1.0 - val), 1.0 / k);
    }

    @Override
    public double quantile(double val) {
        return WeibullDistribution.quantile(val, this.k, this.lambda, this.theta);
    }

    @Override
    public double nextRandom() {
        return this.theta + this.lambda * FastMath.pow(-FastMath.log(1.0 - this.random.nextDouble()), 1.0 / this.k);
    }

    @Override
    public String toString() {
        return "WeibullDistribution(k=" + this.k + ", lambda=" + this.lambda + ", theta=" + this.theta + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double theta;
        double k;
        double lambda;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter kP;
            DoubleParameter lambdaP;
            super.makeOptions(config);
            DoubleParameter thetaP = new DoubleParameter(LOCATION_ID, 0.0);
            if (config.grab(thetaP)) {
                this.theta = thetaP.doubleValue();
            }
            if (config.grab(lambdaP = new DoubleParameter(SCALE_ID))) {
                this.lambda = lambdaP.doubleValue();
            }
            if (config.grab(kP = new DoubleParameter(SHAPE_ID))) {
                this.k = kP.doubleValue();
            }
        }

        @Override
        protected WeibullDistribution makeInstance() {
            return new WeibullDistribution(this.k, this.lambda, this.theta, this.rnd);
        }
    }
}

