/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.StatisticalMoments;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ExponentiallyModifiedGaussianDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MOMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="J. Olivier, M. M. Norberg", title="Positively skewed data: Revisiting the Box-Cox power transformation", booktitle="International Journal of Psychological Research 3(1)", url="https://doi.org/10.21500/20112084.846", bibkey="doi:10.21500/20112084.846")
public class EMGOlivierNorbergEstimator
implements MOMDistributionEstimator<ExponentiallyModifiedGaussianDistribution> {
    public static EMGOlivierNorbergEstimator STATIC = new EMGOlivierNorbergEstimator();

    private EMGOlivierNorbergEstimator() {
    }

    @Override
    public ExponentiallyModifiedGaussianDistribution estimateFromStatisticalMoments(StatisticalMoments moments) {
        double halfsk13 = FastMath.pow(Math.max(0.0, moments.getSampleSkewness() * 0.5), 0.3333333333333333);
        double st = moments.getSampleStddev();
        double mu = moments.getMean() - st * halfsk13;
        double si = st * FastMath.sqrt(Math.abs((1.0 + halfsk13) * (1.0 - halfsk13)));
        double la = halfsk13 > 0.0 ? 1.0 / (st * halfsk13) : 1.0;
        return new ExponentiallyModifiedGaussianDistribution(mu, si, la);
    }

    @Override
    public Class<? super ExponentiallyModifiedGaussianDistribution> getDistributionClass() {
        return ExponentiallyModifiedGaussianDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected EMGOlivierNorbergEstimator makeInstance() {
            return STATIC;
        }
    }
}

