/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ExpGammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

public class ExpGammaExpMOMEstimator
implements DistributionEstimator<ExpGammaDistribution> {
    public static final ExpGammaExpMOMEstimator STATIC = new ExpGammaExpMOMEstimator();

    private ExpGammaExpMOMEstimator() {
    }

    @Override
    public <A> ExpGammaDistribution estimate(A data, NumberArrayAdapter<?, A> adapter) {
        int len = adapter.size(data);
        MeanVariance mv = new MeanVariance();
        for (int i = 0; i < len; ++i) {
            mv.put(FastMath.exp(adapter.getDouble(data, i)));
        }
        return this.estimateFromExpMeanVariance(mv);
    }

    public ExpGammaDistribution estimateFromExpMeanVariance(MeanVariance mv) {
        double mu = mv.getMean();
        double var = mv.getSampleVariance();
        if (mu < Double.MIN_NORMAL || var < Double.MIN_NORMAL) {
            throw new ArithmeticException("Cannot estimate Gamma parameters on a distribution with zero mean or variance: " + mv.toString());
        }
        double theta = mu / var;
        double k = mu * theta;
        if (!(k > 0.0) || !(theta > 0.0)) {
            throw new ArithmeticException("Gamma estimation produced non-positive parameter values: k=" + k + " theta=" + theta);
        }
        return new ExpGammaDistribution(k, theta, 0.0);
    }

    @Override
    public Class<? super ExpGammaDistribution> getDistributionClass() {
        return ExpGammaDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ExpGammaExpMOMEstimator makeInstance() {
            return STATIC;
        }
    }
}

