/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.ExponentialDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J. R. M. Hosking", title="Fortran routines for use with the method of L-moments Version 3.03", booktitle="IBM Research Technical Report", bibkey="tr/ibm/Hosking00")
public class ExponentialLMMEstimator
implements LMMDistributionEstimator<ExponentialDistribution> {
    public static final ExponentialLMMEstimator STATIC = new ExponentialLMMEstimator();

    private ExponentialLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 2;
    }

    @Override
    public ExponentialDistribution estimateFromLMoments(double[] xmom) {
        double scale = 2.0 * xmom[1];
        if (!(scale > 0.0)) {
            throw new ArithmeticException("Data with non-positive scale cannot be exponential distributed.");
        }
        return new ExponentialDistribution(1.0 / scale, xmom[0] - scale);
    }

    @Override
    public Class<? super ExponentialDistribution> getDistributionClass() {
        return ExponentialDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ExponentialLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

