/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.ExponentialDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MADDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="D. J. Olive", title="Applied Robust Statistics", booktitle="", url="http://lagrange.math.siu.edu/Olive/preprints.htm", bibkey="books/Olive08")
public class ExponentialMADEstimator
implements MADDistributionEstimator<ExponentialDistribution> {
    public static final ExponentialMADEstimator STATIC = new ExponentialMADEstimator();

    private ExponentialMADEstimator() {
    }

    @Override
    public ExponentialDistribution estimateFromMedianMAD(double median, double mad) {
        double location = median - 1.44 * mad;
        double scale = 2.0781 * mad;
        if (!(scale > 0.0)) {
            throw new ArithmeticException("Data with non-positive MAD cannot be exponential distributed.");
        }
        return new ExponentialDistribution(1.0 / scale, location);
    }

    @Override
    public Class<? super ExponentialDistribution> getDistributionClass() {
        return ExponentialDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ExponentialMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

