/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ExponentialDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MeanVarianceDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class ExponentialMOMEstimator
implements MeanVarianceDistributionEstimator<ExponentialDistribution> {
    public static final ExponentialMOMEstimator STATIC = new ExponentialMOMEstimator();

    private ExponentialMOMEstimator() {
    }

    @Override
    public ExponentialDistribution estimateFromMeanVariance(MeanVariance mv) {
        double scale = mv.getMean();
        if (!(scale > 0.0)) {
            throw new ArithmeticException("Data with non-positive mean cannot be exponential distributed.");
        }
        return new ExponentialDistribution(1.0 / scale);
    }

    @Override
    public Class<? super ExponentialDistribution> getDistributionClass() {
        return ExponentialDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ExponentialMOMEstimator makeInstance() {
            return STATIC;
        }
    }
}

