/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.ExponentialDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MADDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(title="Robust Estimators for Transformed Location Scale Families", authors="D. J. Olive", booktitle="", bibkey="preprints/Olive06")
public class ExponentialMedianEstimator
implements MADDistributionEstimator<ExponentialDistribution> {
    public static final ExponentialMedianEstimator STATIC = new ExponentialMedianEstimator();

    private ExponentialMedianEstimator() {
    }

    @Override
    public ExponentialDistribution estimateFromMedianMAD(double median, double mad) {
        double scale = 1.441 * median;
        if (!(scale > 0.0)) {
            throw new ArithmeticException("Data with non-positive mean cannot be exponential distributed.");
        }
        return new ExponentialDistribution(1.0 / scale);
    }

    @Override
    public Class<? super ExponentialDistribution> getDistributionClass() {
        return ExponentialDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ExponentialMedianEstimator makeInstance() {
            return STATIC;
        }
    }
}

