/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(title="Maximum likelihood estimation of the parameters of the gamma distribution and their bias", authors="S. C. Choi, R. Wette", booktitle="Technometrics", url="https://doi.org/10.2307/1266892", bibkey="doi:10.2307/1266892")
public class GammaChoiWetteEstimator
implements DistributionEstimator<GammaDistribution> {
    public static final GammaChoiWetteEstimator STATIC = new GammaChoiWetteEstimator();

    private GammaChoiWetteEstimator() {
    }

    @Override
    public <A> GammaDistribution estimate(A data, NumberArrayAdapter<?, A> adapter) {
        double kdelta;
        int len = adapter.size(data);
        double meanx = 0.0;
        double meanlogx = 0.0;
        for (int i = 0; i < len; ++i) {
            double val = adapter.getDouble(data, i);
            if (val <= 0.0 || Double.isInfinite(val) || Double.isNaN(val)) continue;
            double logx = val > 0.0 ? FastMath.log(val) : meanlogx;
            double deltax = val - meanx;
            double deltalogx = logx - meanlogx;
            meanx += deltax / ((double)i + 1.0);
            meanlogx += deltalogx / ((double)i + 1.0);
        }
        double logmeanx = meanx > 0.0 ? FastMath.log(meanx) : meanlogx;
        double diff = logmeanx - meanlogx;
        double k = (3.0 - diff + FastMath.sqrt((diff - 3.0) * (diff - 3.0) + 24.0 * diff)) / (12.0 * diff);
        while (!(Math.abs(kdelta = (FastMath.log(k) - GammaDistribution.digamma(k) - diff) / (1.0 / k - GammaDistribution.trigamma(k))) / k < 1.0E-8) && kdelta < Double.POSITIVE_INFINITY) {
            k += kdelta;
        }
        double theta = k / meanx;
        if (!(k > 0.0) || !(theta > 0.0)) {
            throw new ArithmeticException("Gamma estimation produced non-positive parameter values: k=" + k + " theta=" + theta);
        }
        return new GammaDistribution(k, theta);
    }

    @Override
    public Class<? super GammaDistribution> getDistributionClass() {
        return GammaDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GammaChoiWetteEstimator makeInstance() {
            return STATIC;
        }
    }
}

