/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J. R. M. Hosking", title="Fortran routines for use with the method of L-moments Version 3.03", booktitle="IBM Research Technical Report", bibkey="tr/ibm/Hosking00")
public class GammaLMMEstimator
implements LMMDistributionEstimator<GammaDistribution> {
    public static final GammaLMMEstimator STATIC = new GammaLMMEstimator();
    private static double A1 = -0.308;
    private static double A2 = -0.05812;
    private static double A3 = 0.01765;
    private static double B1 = 0.7213;
    private static double B2 = -0.5947;
    private static double B3 = -2.1817;
    private static double B4 = 1.2113;

    private GammaLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 2;
    }

    @Override
    public GammaDistribution estimateFromLMoments(double[] xmom) {
        double alpha;
        double t;
        double cv = xmom[1] / xmom[0];
        if (cv < 0.5) {
            t = Math.PI * cv * cv;
            alpha = (1.0 + A1 * t) / (t * (1.0 + t * (A2 + t * A3)));
        } else {
            t = 1.0 - cv;
            alpha = t * (B1 + t * B2) / (1.0 + t * (B3 + t * B4));
        }
        double theta = alpha / xmom[0];
        if (!(alpha > 0.0) || !(theta > 0.0)) {
            throw new ArithmeticException("Gamma estimation produced non-positive parameter values: k=" + alpha + " theta=" + theta);
        }
        return new GammaDistribution(alpha, theta);
    }

    @Override
    public Class<? super GammaDistribution> getDistributionClass() {
        return GammaDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GammaLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

