/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MeanVarianceDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="G. Casella, R. L. Berger", title="Point Estimation (Chapter 7)", booktitle="Statistical inference. Vol. 70", bibkey="books/duxbury/CasellaB90/Ch7")
public class GammaMOMEstimator
implements MeanVarianceDistributionEstimator<GammaDistribution> {
    public static final GammaMOMEstimator STATIC = new GammaMOMEstimator();

    private GammaMOMEstimator() {
    }

    @Override
    public GammaDistribution estimateFromMeanVariance(MeanVariance mv) {
        double mu = mv.getMean();
        double var = mv.getSampleVariance();
        if (mu < Double.MIN_NORMAL || var < Double.MIN_NORMAL) {
            throw new ArithmeticException("Cannot estimate Gamma parameters on a distribution with zero mean or variance: " + mv.toString());
        }
        double theta = mu / var;
        double k = mu * theta;
        if (!(k > 0.0) || !(theta > 0.0)) {
            throw new ArithmeticException("Gamma estimation produced non-positive parameter values: k=" + k + " theta=" + theta);
        }
        return new GammaDistribution(k, theta);
    }

    @Override
    public Class<? super GammaDistribution> getDistributionClass() {
        return GammaDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GammaMOMEstimator makeInstance() {
            return STATIC;
        }
    }
}

