/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GeneralizedExtremeValueDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="J. R. M. Hosking, J. R. Wallis, E. F. Wood", title="Estimation of the generalized extreme-value distribution by the method of probability-weighted moments.", booktitle="Technometrics 27.3", url="https://doi.org/10.1080/00401706.1985.10488049", bibkey="doi:10.1080/00401706.1985.10488049")
public class GeneralizedExtremeValueLMMEstimator
implements LMMDistributionEstimator<GeneralizedExtremeValueDistribution> {
    public static final GeneralizedExtremeValueLMMEstimator STATIC = new GeneralizedExtremeValueLMMEstimator();
    protected static final double A0 = 0.2837753;
    protected static final double A1 = -1.21096399;
    protected static final double A2 = -2.50728214;
    protected static final double A3 = -1.13455566;
    protected static final double A4 = -0.07138022;
    protected static final double B1 = 2.06189696;
    protected static final double B2 = 1.31912239;
    protected static final double B3 = 0.25077104;
    protected static final double C1 = 1.59921491;
    protected static final double C2 = -0.48832213;
    protected static final double C3 = 0.01573152;
    protected static final double D1 = -0.64363929;
    protected static final double D2 = 0.08985247;
    protected static final double EU = 0.5772156649015329;
    static int MAXIT = 20;

    private GeneralizedExtremeValueLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 3;
    }

    @Override
    public GeneralizedExtremeValueDistribution estimateFromLMoments(double[] xmom) {
        double g;
        double t3 = xmom[2];
        if (Math.abs(t3) < 1.0E-50 || t3 >= 1.0) {
            throw new ArithmeticException("Invalid moment estimation.");
        }
        if (t3 > 0.0) {
            double z = 1.0 - t3;
            g = (-1.0 + z * (1.59921491 + z * (-0.48832213 + z * 0.01573152))) / (1.0 + z * (-0.64363929 + z * 0.08985247));
            if (Math.abs(g) < 1.0E-50) {
                double k = 0.0;
                double sigma = xmom[1] * MathUtil.ONE_BY_LOG2;
                double mu = xmom[0] - 0.5772156649015329 * sigma;
                return new GeneralizedExtremeValueDistribution(mu, sigma, k);
            }
        } else {
            g = (0.2837753 + t3 * (-1.21096399 + t3 * (-2.50728214 + t3 * (-1.13455566 + t3 * -0.07138022)))) / (1.0 + t3 * (2.06189696 + t3 * (1.31912239 + t3 * 0.25077104)));
            if (t3 < -0.8) {
                if (t3 <= -0.97) {
                    g = 1.0 - FastMath.log1p(t3) * MathUtil.ONE_BY_LOG2;
                }
                double t0 = 0.5 * (t3 + 3.0);
                int it = 1;
                while (true) {
                    double oldg;
                    double deriv;
                    double x3;
                    double xx3;
                    double t;
                    double x2 = FastMath.pow(2.0, -g);
                    double xx2 = 1.0 - x2;
                    if (Math.abs((g -= ((t = (xx3 = 1.0 - (x3 = FastMath.pow(3.0, -g))) / xx2) - t0) / (deriv = (xx2 * x3 * MathUtil.LOG3 - xx3 * x2 * MathUtil.LOG2) / (xx2 * xx2))) - (oldg = g)) < 1.0E-14 * g) break;
                    if (it >= MAXIT) {
                        throw new ArithmeticException("Newton-Raphson did not converge.");
                    }
                    ++it;
                }
            }
        }
        double gam = FastMath.exp(GammaDistribution.logGamma(1.0 + g));
        double k = g;
        double sigma = xmom[1] * g / (gam * (1.0 - FastMath.pow(2.0, -g)));
        double mu = xmom[0] - sigma * (1.0 - gam) / g;
        return new GeneralizedExtremeValueDistribution(mu, sigma, k);
    }

    @Override
    public Class<? super GeneralizedExtremeValueDistribution> getDistributionClass() {
        return GeneralizedExtremeValueDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GeneralizedExtremeValueLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

