/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.GeneralizedLogisticAlternateDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="J. R. M. Hosking", title="Fortran routines for use with the method of L-moments Version 3.03", booktitle="IBM Research Technical Report", bibkey="tr/ibm/Hosking00")
public class GeneralizedLogisticAlternateLMMEstimator
implements LMMDistributionEstimator<GeneralizedLogisticAlternateDistribution> {
    public static final GeneralizedLogisticAlternateLMMEstimator STATIC = new GeneralizedLogisticAlternateLMMEstimator();

    private GeneralizedLogisticAlternateLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 3;
    }

    @Override
    public GeneralizedLogisticAlternateDistribution estimateFromLMoments(double[] xmom) {
        double shape = -xmom[2];
        if (!(shape >= -1.0) || !(shape <= 1.0)) {
            throw new ArithmeticException("Invalid moment estimation.");
        }
        if (Math.abs(shape) < 1.0E-6) {
            return new GeneralizedLogisticAlternateDistribution(xmom[0], xmom[1], 0.0);
        }
        double tmp = shape * Math.PI / FastMath.sin(shape * Math.PI);
        double scale = xmom[1] / tmp;
        double location = xmom[0] - scale * (1.0 - tmp) / shape;
        return new GeneralizedLogisticAlternateDistribution(location, scale, shape);
    }

    @Override
    public Class<? super GeneralizedLogisticAlternateDistribution> getDistributionClass() {
        return GeneralizedLogisticAlternateDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GeneralizedLogisticAlternateLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

