/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.GeneralizedParetoDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J. R. M. Hosking, J. R. Wallis, E. F. Wood", title="Estimation of the generalized extreme-value distribution by the method of probability-weighted moments.", booktitle="Technometrics 27.3", url="https://doi.org/10.1080/00401706.1985.10488049", bibkey="doi:10.1080/00401706.1985.10488049")
public class GeneralizedParetoLMMEstimator
implements LMMDistributionEstimator<GeneralizedParetoDistribution> {
    public static final GeneralizedParetoLMMEstimator STATIC = new GeneralizedParetoLMMEstimator();

    private GeneralizedParetoLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 3;
    }

    @Override
    public GeneralizedParetoDistribution estimateFromLMoments(double[] xmom) {
        double t3 = xmom[2];
        if (Math.abs(t3) >= 1.0) {
            throw new ArithmeticException("Invalid moment estimation.");
        }
        double kappa = (1.0 - 3.0 * t3) / (1.0 + t3);
        double sigma = (1.0 + kappa) * (2.0 + kappa) * xmom[1];
        double mu = xmom[0] - sigma / (1.0 + kappa);
        return new GeneralizedParetoDistribution(mu, sigma, -kappa);
    }

    @Override
    public Class<? super GeneralizedParetoDistribution> getDistributionClass() {
        return GeneralizedParetoDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GeneralizedParetoLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

