/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GumbelDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J. R. M. Hosking", title="Fortran routines for use with the method of L-moments Version 3.03", booktitle="IBM Research Technical Report", bibkey="tr/ibm/Hosking00")
public class GumbelLMMEstimator
implements LMMDistributionEstimator<GumbelDistribution> {
    public static final GumbelLMMEstimator STATIC = new GumbelLMMEstimator();

    private GumbelLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 2;
    }

    @Override
    public GumbelDistribution estimateFromLMoments(double[] xmom) {
        double scale = xmom[1] * MathUtil.ONE_BY_LOG2;
        return new GumbelDistribution(xmom[0] - scale / Math.E, scale);
    }

    @Override
    public Class<? super GumbelDistribution> getDistributionClass() {
        return GumbelDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GumbelLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

