/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.GumbelDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MADDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="D. J. Olive", title="Applied Robust Statistics", booktitle="", url="http://lagrange.math.siu.edu/Olive/preprints.htm", bibkey="books/Olive08")
public class GumbelMADEstimator
implements MADDistributionEstimator<GumbelDistribution> {
    public static final GumbelMADEstimator STATIC = new GumbelMADEstimator();

    private GumbelMADEstimator() {
    }

    @Override
    public GumbelDistribution estimateFromMedianMAD(double median, double mad) {
        return new GumbelDistribution(median - 0.4778 * mad, 1.3037 * mad);
    }

    @Override
    public Class<? super GumbelDistribution> getDistributionClass() {
        return GumbelDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GumbelMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

