/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.InverseGaussianDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.WaldMLEstimator"})
public class InverseGaussianMLEstimator
implements DistributionEstimator<InverseGaussianDistribution> {
    public static final InverseGaussianMLEstimator STATIC = new InverseGaussianMLEstimator();

    @Override
    public <A> InverseGaussianDistribution estimate(A data, NumberArrayAdapter<?, A> adapter) {
        int len = adapter.size(data);
        double mean = 0.0;
        for (int i = 0; i < len; ++i) {
            double v = adapter.getDouble(data, i);
            mean += v;
        }
        double invmean = 1.0 / (mean /= (double)len);
        double invdev = 0.0;
        for (int i = 0; i < len; ++i) {
            double v = adapter.getDouble(data, i);
            if (!(v > 0.0)) continue;
            invdev += 1.0 / v - invmean;
        }
        return new InverseGaussianDistribution(mean, (double)len / invdev);
    }

    @Override
    public Class<? super InverseGaussianDistribution> getDistributionClass() {
        return InverseGaussianDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected InverseGaussianMLEstimator makeInstance() {
            return STATIC;
        }
    }
}

