/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.InverseGaussianDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MeanVarianceDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.WaldMOMEstimator"})
public class InverseGaussianMOMEstimator
implements MeanVarianceDistributionEstimator<InverseGaussianDistribution> {
    public static final InverseGaussianMOMEstimator STATIC = new InverseGaussianMOMEstimator();

    @Override
    public InverseGaussianDistribution estimateFromMeanVariance(MeanVariance mv) {
        double mean = mv.getMean();
        return new InverseGaussianDistribution(mean, mean * mean * mean / mv.getSampleVariance());
    }

    @Override
    public Class<? super InverseGaussianDistribution> getDistributionClass() {
        return InverseGaussianDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected InverseGaussianMOMEstimator makeInstance() {
            return STATIC;
        }
    }
}

