/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.ProbabilityWeightedMoments;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import java.util.Arrays;

public interface LMMDistributionEstimator<D extends Distribution>
extends DistributionEstimator<D> {
    public D estimateFromLMoments(double[] var1);

    public int getNumMoments();

    @Override
    default public <A> D estimate(A data, NumberArrayAdapter<?, A> adapter) {
        int size = adapter.size(data);
        double[] sorted = new double[size];
        for (int i = 0; i < size; ++i) {
            sorted[i] = adapter.getDouble(data, i);
        }
        Arrays.sort(sorted);
        double[] xmom = ProbabilityWeightedMoments.samLMR(sorted, DoubleArrayAdapter.STATIC, this.getNumMoments());
        return this.estimateFromLMoments(xmom);
    }
}

