/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.LaplaceDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class LaplaceLMMEstimator
implements LMMDistributionEstimator<LaplaceDistribution> {
    public static final LaplaceLMMEstimator STATIC = new LaplaceLMMEstimator();

    private LaplaceLMMEstimator() {
    }

    @Override
    public LaplaceDistribution estimateFromLMoments(double[] xmom) {
        double location = xmom[0];
        double scale = 1.3333333333333333 * xmom[1];
        return new LaplaceDistribution(1.0 / scale, location);
    }

    @Override
    public int getNumMoments() {
        return 2;
    }

    @Override
    public Class<? super LaplaceDistribution> getDistributionClass() {
        return LaplaceDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LaplaceLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

