/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.LaplaceDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MADDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="D. J. Olive", title="Applied Robust Statistics", booktitle="", url="http://lagrange.math.siu.edu/Olive/preprints.htm", bibkey="books/Olive08")
public class LaplaceMADEstimator
implements MADDistributionEstimator<LaplaceDistribution> {
    public static final LaplaceMADEstimator STATIC = new LaplaceMADEstimator();

    private LaplaceMADEstimator() {
    }

    @Override
    public LaplaceDistribution estimateFromMedianMAD(double median, double mad) {
        double location = median;
        double scale = 1.443 * mad;
        return new LaplaceDistribution(1.0 / scale, location);
    }

    @Override
    public Class<? super LaplaceDistribution> getDistributionClass() {
        return LaplaceDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LaplaceMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

