/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.LaplaceDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(title="The Double Exponential Distribution: Using Calculus to Find a Maximum Likelihood Estimator", authors="R. M. Norton", booktitle="The American Statistician 38 (2)", url="https://doi.org/10.2307/2683252", bibkey="doi:10.2307/2683252")
public class LaplaceMLEEstimator
implements DistributionEstimator<LaplaceDistribution> {
    public static final LaplaceMLEEstimator STATIC = new LaplaceMLEEstimator();

    private LaplaceMLEEstimator() {
    }

    @Override
    public <A> LaplaceDistribution estimate(A data, NumberArrayAdapter<?, A> adapter) {
        int len = adapter.size(data);
        double[] temp = new double[len];
        for (int i = 0; i < len; ++i) {
            temp[i] = adapter.getDouble(data, i);
        }
        double location = QuickSelect.median(temp);
        double meandev = 0.0;
        for (int i = 0; i < len; ++i) {
            meandev += Math.abs(temp[i] - location);
        }
        return new LaplaceDistribution((double)len / meandev, location);
    }

    @Override
    public Class<? super LaplaceDistribution> getDistributionClass() {
        return LaplaceDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LaplaceMLEEstimator makeInstance() {
            return STATIC;
        }
    }
}

