/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.StatisticalMoments;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogGammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogMOMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class LogGammaLogMOMEstimator
implements LogMOMDistributionEstimator<LogGammaDistribution> {
    public static final LogGammaLogMOMEstimator STATIC = new LogGammaLogMOMEstimator();

    private LogGammaLogMOMEstimator() {
    }

    @Override
    public LogGammaDistribution estimateFromLogStatisticalMoments(StatisticalMoments mv, double shift) {
        double mu = mv.getMean();
        double var = mv.getSampleVariance();
        if (mu < Double.MIN_NORMAL || var < Double.MIN_NORMAL) {
            throw new ArithmeticException("Cannot estimate Gamma parameters on a distribution with zero mean or variance: " + mv.toString());
        }
        double theta = mu / var;
        double k = mu * theta;
        if (!(k > 0.0) || !(theta > 0.0)) {
            throw new ArithmeticException("Gamma estimation produced non-positive parameter values: k=" + k + " theta=" + theta);
        }
        return new LogGammaDistribution(k, theta, shift);
    }

    @Override
    public Class<? super LogGammaDistribution> getDistributionClass() {
        return LogGammaDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogGammaLogMOMEstimator makeInstance() {
            return STATIC;
        }
    }
}

