/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogLogisticDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogMADDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="D. J. Olive", title="Applied Robust Statistics", booktitle="", url="http://lagrange.math.siu.edu/Olive/preprints.htm", bibkey="books/Olive08")
public class LogLogisticMADEstimator
implements LogMADDistributionEstimator<LogLogisticDistribution> {
    public static final LogLogisticMADEstimator STATIC = new LogLogisticMADEstimator();

    private LogLogisticMADEstimator() {
    }

    @Override
    public LogLogisticDistribution estimateFromLogMedianMAD(double median, double mad, double shift) {
        return new LogLogisticDistribution(mad / MathUtil.LOG3, shift, FastMath.exp(median) - shift);
    }

    @Override
    public Class<? super LogLogisticDistribution> getDistributionClass() {
        return LogLogisticDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogLogisticMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

