/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogMOMDistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MADDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import net.jafama.FastMath;

public interface LogMADDistributionEstimator<D extends Distribution>
extends DistributionEstimator<D> {
    public D estimateFromLogMedianMAD(double var1, double var3, double var5);

    @Override
    default public <A> D estimate(A data, NumberArrayAdapter<?, A> adapter) {
        int len = adapter.size(data);
        double min = LogMOMDistributionEstimator.min(data, adapter, 0.0, 1.0E-10);
        double[] x = new double[len];
        for (int i = 0; i < len; ++i) {
            double val = adapter.getDouble(data, i) - min;
            double d = x[i] = val > 0.0 ? FastMath.log(val) : Double.NEGATIVE_INFINITY;
            if (!Double.isNaN(x[i])) continue;
            throw new ArithmeticException("NaN value.");
        }
        double median = QuickSelect.median(x);
        double mad = MADDistributionEstimator.computeMAD(x, x.length, median);
        return this.estimateFromLogMedianMAD(median, mad, min);
    }
}

