/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.StatisticalMoments;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import net.jafama.FastMath;

public interface LogMOMDistributionEstimator<D extends Distribution>
extends DistributionEstimator<D> {
    public D estimateFromLogStatisticalMoments(StatisticalMoments var1, double var2);

    @Override
    default public <A> D estimate(A data, NumberArrayAdapter<?, A> adapter) {
        int len = adapter.size(data);
        double min = LogMOMDistributionEstimator.min(data, adapter, 0.0, 1.0E-10);
        StatisticalMoments mv = new StatisticalMoments();
        for (int i = 0; i < len; ++i) {
            double val = adapter.getDouble(data, i) - min;
            if (Double.isInfinite(val) || Double.isNaN(val) || val <= 0.0) continue;
            mv.put(FastMath.log(val));
        }
        return this.estimateFromLogStatisticalMoments(mv, min);
    }

    public static <A> double min(A data, NumberArrayAdapter<?, A> adapter, double minmin, double margin) {
        double min;
        int len = adapter.size(data);
        double max = min = adapter.getDouble(data, 0);
        for (int i = 1; i < len; ++i) {
            double val = adapter.getDouble(data, i);
            if (val < min) {
                min = val;
                continue;
            }
            if (!(val > max)) continue;
            max = val;
        }
        if (min > minmin) {
            return minmin;
        }
        return min - (max - min) * margin;
    }
}

