/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.StatisticalMoments;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogMOMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import net.jafama.FastMath;

public interface LogMeanVarianceEstimator<D extends Distribution>
extends LogMOMDistributionEstimator<D> {
    public D estimateFromLogMeanVariance(MeanVariance var1, double var2);

    @Override
    default public D estimateFromLogStatisticalMoments(StatisticalMoments moments, double shift) {
        if (!(moments.getCount() > 1.0)) {
            throw new ArithmeticException("Too small sample size to estimate variance.");
        }
        return this.estimateFromLogMeanVariance(moments, shift);
    }

    @Override
    default public <A> D estimate(A data, NumberArrayAdapter<?, A> adapter) {
        int len = adapter.size(data);
        double min = LogMOMDistributionEstimator.min(data, adapter, 0.0, 1.0E-10);
        MeanVariance mv = new MeanVariance();
        for (int i = 0; i < len; ++i) {
            double val = adapter.getDouble(data, i) - min;
            if (Double.isInfinite(val) || Double.isNaN(val) || val <= 0.0) continue;
            mv.put(FastMath.log(val));
        }
        if (!(mv.getCount() > 1.0)) {
            throw new ArithmeticException("Too small sample size to estimate variance.");
        }
        return this.estimateFromLogMeanVariance(mv, min);
    }
}

