/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogNormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="D. B\u00edlkov\u00e1", title="Lognormal distribution and using L-moment method for estimating its parameters", booktitle="Int. Journal of Mathematical Models and Methods in Applied Sciences (NAUN)", url="http://www.naun.org/multimedia/NAUN/m3as/17-079.pdf", bibkey="journals/naun/Bilkova12")
public class LogNormalBilkovaLMMEstimator
implements LMMDistributionEstimator<LogNormalDistribution> {
    public static final LogNormalBilkovaLMMEstimator STATIC = new LogNormalBilkovaLMMEstimator();
    private static final double SQRT8_3 = Math.sqrt(2.6666666666666665);

    private LogNormalBilkovaLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 3;
    }

    @Override
    public LogNormalDistribution estimateFromLMoments(double[] xmom) {
        if (!(xmom[1] > 0.0 && Math.abs(xmom[2]) < 1.0 && xmom[2] > 0.0)) {
            throw new ArithmeticException("L-Moments invalid");
        }
        double z = SQRT8_3 * NormalDistribution.standardNormalQuantile(0.5 * (1.0 + xmom[2]));
        double z2 = z * z;
        double sigma = 0.999281 * z - 0.006118 * z * z2 + 1.27E-4 * z * z2 * z2;
        double sigmasqhalf = sigma * sigma * 0.5;
        double logmu = FastMath.log(xmom[1] / NormalDistribution.erf(0.5 * sigma)) - sigmasqhalf;
        return new LogNormalDistribution(logmu, Math.max(sigma, Double.MIN_NORMAL), xmom[0] - FastMath.exp(logmu + sigmasqhalf));
    }

    @Override
    public Class<? super LogNormalDistribution> getDistributionClass() {
        return LogNormalDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogNormalBilkovaLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

