/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogNormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="J. R. M. Hosking", title="Fortran routines for use with the method of L-moments Version 3.03", booktitle="IBM Research Technical Report", bibkey="tr/ibm/Hosking00")
public class LogNormalLMMEstimator
implements LMMDistributionEstimator<LogNormalDistribution> {
    public static final LogNormalLMMEstimator STATIC = new LogNormalLMMEstimator();
    private static final double A0 = 2.0466534;
    private static final double A1 = -3.6544371;
    private static final double A2 = 1.8396733;
    private static final double A3 = -0.20360244;
    private static final double B1 = -2.0182173;
    private static final double B2 = 1.2420401;
    private static final double B3 = -0.21741801;

    private LogNormalLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 3;
    }

    @Override
    public LogNormalDistribution estimateFromLMoments(double[] xmom) {
        double shape;
        double scale;
        double location;
        if (!(xmom[1] > 0.0 && Math.abs(xmom[2]) < 1.0 && xmom[2] > 0.0)) {
            throw new ArithmeticException("L-Moments invalid");
        }
        double t3 = xmom[2];
        if (Math.abs(t3) >= 0.95) {
            location = 0.0;
            scale = -1.0;
            shape = 0.0;
        } else if (Math.abs(t3) < 1.0E-8) {
            location = xmom[0];
            scale = xmom[1] * MathUtil.SQRTPI;
            shape = 0.0;
        } else {
            double tt = t3 * t3;
            shape = -t3 * (2.0466534 + tt * (-3.6544371 + tt * (1.8396733 + tt * -0.20360244))) / (1.0 + tt * (-2.0182173 + tt * (1.2420401 + tt * -0.21741801)));
            double e = FastMath.exp(0.5 * shape * shape);
            scale = xmom[1] * shape / (e * NormalDistribution.erf(0.5 * shape));
            location = xmom[0] + scale * (e - 1.0) / shape;
        }
        double sigma = -shape;
        double expmu = scale / sigma;
        return new LogNormalDistribution(FastMath.log(expmu), Math.max(sigma, Double.MIN_NORMAL), location - expmu);
    }

    @Override
    public Class<? super LogNormalDistribution> getDistributionClass() {
        return LogNormalDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogNormalLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

