/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.linearalgebra.fitting.GaussianFittingFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.fitting.LevenbergMarquardtMethod;
import de.lmu.ifi.dbs.elki.math.statistics.KernelDensityEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogNormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.GaussianKernelDensityFunction;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.Arrays;
import net.jafama.FastMath;

public class LogNormalLevenbergMarquardtKDEEstimator
implements DistributionEstimator<LogNormalDistribution> {
    public static final LogNormalLevenbergMarquardtKDEEstimator STATIC = new LogNormalLevenbergMarquardtKDEEstimator();

    private LogNormalLevenbergMarquardtKDEEstimator() {
    }

    @Override
    public <A> LogNormalDistribution estimate(A data, NumberArrayAdapter<?, A> adapter) {
        int len = adapter.size(data);
        MeanVariance mv = new MeanVariance();
        double[] x = new double[len];
        for (int i = 0; i < len; ++i) {
            double val = adapter.getDouble(data, i);
            if (!(val > 0.0)) {
                throw new ArithmeticException("Cannot fit logNormal to a data set which includes non-positive values: " + val);
            }
            x[i] = FastMath.log(val);
            mv.put(x[i]);
        }
        Arrays.sort(x);
        double median = (x[len >> 1] + x[len + 1 >> 1]) * 0.5;
        KernelDensityEstimator de = new KernelDensityEstimator(x, GaussianKernelDensityFunction.KERNEL, 1.0E-6);
        double[] y = de.getDensity();
        double[] s = new double[len];
        Arrays.fill(s, 1.0);
        double[] params = new double[]{median, mv.getSampleStddev(), 1.0};
        boolean[] dofit = new boolean[]{true, true, false};
        LevenbergMarquardtMethod fit = new LevenbergMarquardtMethod(GaussianFittingFunction.STATIC, params, dofit, x, y, s);
        fit.run();
        double[] ps = fit.getParams();
        return new LogNormalDistribution(ps[0], ps[1], 0.0);
    }

    @Override
    public Class<? super LogNormalDistribution> getDistributionClass() {
        return LogNormalDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogNormalLevenbergMarquardtKDEEstimator makeInstance() {
            return STATIC;
        }
    }
}

