/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogNormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogMADDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="F. R. Hampel", title="The Influence Curve and Its Role in Robust Estimation", booktitle="Journal of the American Statistical Association, June 1974, Vol. 69, No. 346", url="https://doi.org/10.2307/2285666", bibkey="doi:10.2307/2285666")
public class LogNormalLogMADEstimator
implements LogMADDistributionEstimator<LogNormalDistribution> {
    public static LogNormalLogMADEstimator STATIC = new LogNormalLogMADEstimator();

    private LogNormalLogMADEstimator() {
    }

    @Override
    public LogNormalDistribution estimateFromLogMedianMAD(double median, double mad, double shift) {
        return new LogNormalDistribution(median, Math.max(1.4826022185056018 * mad, Double.MIN_NORMAL), shift);
    }

    @Override
    public Class<? super LogNormalDistribution> getDistributionClass() {
        return LogNormalDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogNormalLogMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

