/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogisticDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J. R. M. Hosking", title="Fortran routines for use with the method of L-moments Version 3.03", booktitle="IBM Research Technical Report", bibkey="tr/ibm/Hosking00")
public class LogisticLMMEstimator
implements LMMDistributionEstimator<LogisticDistribution> {
    public static final LogisticLMMEstimator STATIC = new LogisticLMMEstimator();

    private LogisticLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 2;
    }

    @Override
    public LogisticDistribution estimateFromLMoments(double[] xmom) {
        return new LogisticDistribution(xmom[0], xmom[1]);
    }

    @Override
    public Class<? super LogisticDistribution> getDistributionClass() {
        return LogisticDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogisticLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

